/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert.impl;

import com.ccb.core.convert.AbstractConverter;
import com.ccb.core.lang.EnumItem;
import com.ccb.core.lang.SimpleCache;
import com.ccb.core.map.MapUtil;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.EnumUtil;
import com.ccb.core.util.ModifierUtil;
import com.ccb.core.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class EnumConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private static final SimpleCache VALUE_OF_METHOD_CACHE = new SimpleCache();
    private final Class enumClass;

    public EnumConverter(Class clazz) {
        this.enumClass = clazz;
    }

    @Override
    protected Object convertInternal(Object object) {
        Enum enum_ = EnumConverter.tryConvertEnum(object, this.enumClass);
        if (null == enum_ && !(object instanceof String)) {
            enum_ = Enum.valueOf(this.enumClass, this.convertToStr(object));
        }
        return enum_;
    }

    @Override
    public Class getTargetType() {
        return this.enumClass;
    }

    protected static Enum tryConvertEnum(Object object, Class clazz) {
        Object object2;
        if (object == null) {
            return null;
        }
        Enum enum_ = null;
        if (EnumItem.class.isAssignableFrom(clazz) && null != (object2 = (EnumItem)((Object)EnumUtil.getEnumAt(clazz, 0)))) {
            if (object instanceof Integer) {
                return (Enum)((Object)object2.fromInt((Integer)object));
            }
            if (object instanceof String) {
                return (Enum)((Object)object2.fromStr(object.toString()));
            }
        }
        if (MapUtil.isNotEmpty((Map)(object2 = EnumConverter.getMethodMap(clazz)))) {
            Class<?> clazz2 = object.getClass();
            for (Map.Entry entry : object2.entrySet()) {
                if (!ClassUtil.isAssignable((Class)entry.getKey(), clazz2)) continue;
                enum_ = (Enum)ReflectUtil.invokeStatic((Method)entry.getValue(), object);
            }
        }
        if (null == enum_) {
            if (object instanceof Integer) {
                enum_ = EnumUtil.getEnumAt(clazz, (Integer)object);
            } else if (object instanceof String) {
                try {
                    enum_ = Enum.valueOf(clazz, (String)object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return enum_;
    }

    private static Map getMethodMap(Class clazz) {
        return (Map)VALUE_OF_METHOD_CACHE.get(clazz, () -> Arrays.stream(clazz.getMethods()).filter(ModifierUtil::isStatic).filter(method -> method.getReturnType() == clazz).filter(method -> method.getParameterCount() == 1).filter(method -> false == "valueOf".equals(method.getName())).collect(Collectors.toMap(method -> method.getParameterTypes()[0], method -> method)));
    }
}

