/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert.impl;

import com.ccb.core.convert.AbstractConverter;
import com.ccb.core.date.DateTime;
import com.ccb.core.date.DateUtil;
import com.ccb.core.util.StrUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private final Class targetType;
    private String format;

    public DateConverter(Class clazz) {
        this.targetType = clazz;
    }

    public DateConverter(Class clazz, String string) {
        this.targetType = clazz;
        this.format = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    @Override
    protected Date convertInternal(Object object) {
        Long l2 = null;
        if (object instanceof Calendar) {
            l2 = ((Calendar)object).getTimeInMillis();
        } else if (object instanceof Number) {
            l2 = ((Number)object).longValue();
        } else {
            if (object instanceof TemporalAccessor) {
                return DateUtil.date((TemporalAccessor)object);
            }
            String string = this.convertToStr(object);
            Date date = null;
            try {
                date = StrUtil.isBlank(this.format) ? DateUtil.parse(string) : DateUtil.parse((CharSequence)string, this.format);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != date) {
                l2 = date.getTime();
            }
        }
        if (null == l2) {
            return null;
        }
        if (Date.class == this.targetType) {
            return new Date(l2);
        }
        if (DateTime.class == this.targetType) {
            return new DateTime(l2);
        }
        if (java.sql.Date.class == this.targetType) {
            return new java.sql.Date(l2);
        }
        if (Time.class == this.targetType) {
            return new Time(l2);
        }
        if (Timestamp.class == this.targetType) {
            return new Timestamp(l2);
        }
        throw new UnsupportedOperationException(StrUtil.format((CharSequence)"Unsupport Date type: {}", this.targetType.getName()));
    }
}

