/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert.impl;

import com.ccb.core.bean.BeanUtil;
import com.ccb.core.bean.copier.BeanCopier;
import com.ccb.core.bean.copier.CopyOptions;
import com.ccb.core.bean.copier.ValueProvider;
import com.ccb.core.convert.AbstractConverter;
import com.ccb.core.convert.ConvertException;
import com.ccb.core.map.MapProxy;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private final Type beanType;
    private final Class beanClass;
    private final CopyOptions copyOptions;

    public BeanConverter(Type type) {
        this(type, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Class clazz) {
        this(clazz, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Type type, CopyOptions copyOptions) {
        this.beanType = type;
        this.beanClass = TypeUtil.getClass(type);
        this.copyOptions = copyOptions;
    }

    @Override
    protected Object convertInternal(Object object) {
        if (object instanceof Map || object instanceof ValueProvider || BeanUtil.isBean(object.getClass())) {
            if (object instanceof Map && this.beanClass.isInterface()) {
                return MapProxy.create((Map)object).toProxyBean(this.beanClass);
            }
            return BeanCopier.create(object, ReflectUtil.newInstanceIfPossible(this.beanClass), this.beanType, this.copyOptions).copy();
        }
        if (object instanceof byte[]) {
            return ObjectUtil.deserialize((byte[])object);
        }
        throw new ConvertException("Unsupported source type: {}", object.getClass());
    }

    @Override
    public Class getTargetType() {
        return this.beanClass;
    }
}

