/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert.impl;

import com.ccb.core.collection.IterUtil;
import com.ccb.core.convert.AbstractConverter;
import com.ccb.core.convert.Convert;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private final Class targetType;
    private final Class targetComponentType;
    private boolean ignoreElementError;

    public ArrayConverter(Class clazz) {
        this(clazz, false);
    }

    public ArrayConverter(Class clazz, boolean bl) {
        if (null == clazz) {
            clazz = Object[].class;
        }
        if (clazz.isArray()) {
            this.targetType = clazz;
            this.targetComponentType = clazz.getComponentType();
        } else {
            this.targetComponentType = clazz;
            this.targetType = ArrayUtil.getArrayType(clazz);
        }
        this.ignoreElementError = bl;
    }

    @Override
    protected Object convertInternal(Object object) {
        return object.getClass().isArray() ? this.convertArrayToArray(object) : this.convertObjectToArray(object);
    }

    @Override
    public Class getTargetType() {
        return this.targetType;
    }

    public void setIgnoreElementError(boolean bl) {
        this.ignoreElementError = bl;
    }

    private Object convertArrayToArray(Object object) {
        Class clazz = ArrayUtil.getComponentType(object);
        if (clazz == this.targetComponentType) {
            return object;
        }
        int n2 = ArrayUtil.length(object);
        Object object2 = Array.newInstance(this.targetComponentType, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Array.set(object2, i2, this.convertComponentType(Array.get(object, i2)));
        }
        return object2;
    }

    private Object convertObjectToArray(Object object) {
        Object object2;
        if (object instanceof CharSequence) {
            if (this.targetComponentType == Character.TYPE || this.targetComponentType == Character.class) {
                return this.convertArrayToArray(object.toString().toCharArray());
            }
            String[] stringArray = StrUtil.split((CharSequence)object.toString(), ",");
            return this.convertArrayToArray(stringArray);
        }
        if (object instanceof List) {
            List list = (List)object;
            object2 = Array.newInstance(this.targetComponentType, list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Array.set(object2, i2, this.convertComponentType(list.get(i2)));
            }
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            object2 = Array.newInstance(this.targetComponentType, collection.size());
            int n2 = 0;
            for (Object e2 : collection) {
                Array.set(object2, n2, this.convertComponentType(e2));
                ++n2;
            }
        } else if (object instanceof Iterable) {
            List list = IterUtil.toList((Iterable)object);
            object2 = Array.newInstance(this.targetComponentType, list.size());
            for (int i3 = 0; i3 < list.size(); ++i3) {
                Array.set(object2, i3, this.convertComponentType(list.get(i3)));
            }
        } else if (object instanceof Iterator) {
            List list = IterUtil.toList((Iterator)object);
            object2 = Array.newInstance(this.targetComponentType, list.size());
            for (int i4 = 0; i4 < list.size(); ++i4) {
                Array.set(object2, i4, this.convertComponentType(list.get(i4)));
            }
        } else {
            object2 = object instanceof Serializable && Byte.TYPE == this.targetComponentType ? (Object)ObjectUtil.serialize(object) : this.convertToSingleElementArray(object);
        }
        return object2;
    }

    private Object[] convertToSingleElementArray(Object object) {
        Object[] objectArray = ArrayUtil.newArray(this.targetComponentType, 1);
        objectArray[0] = this.convertComponentType(object);
        return objectArray;
    }

    private Object convertComponentType(Object object) {
        return Convert.convertWithCheck(this.targetComponentType, object, null, this.ignoreElementError);
    }
}

