/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert;

import com.ccb.core.util.StrUtil;

public class NumberChineseFormatter {
    private static final String[] SIMPLE_DIGITS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] TRADITIONAL_DIGITS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] SIMPLE_UNITS = new String[]{"", "\u5341", "\u767e", "\u5343"};
    private static final String[] TRADITIONAL_UNITS = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};

    public static String format(double d2, boolean bl) {
        return NumberChineseFormatter.format(d2, bl, false);
    }

    public static String format(double d2, boolean bl, boolean bl2) {
        String[] stringArray;
        String[] stringArray2 = stringArray = bl ? TRADITIONAL_DIGITS : SIMPLE_DIGITS;
        if (d2 > 9.999999999999998E13 || d2 < -9.999999999999998E13) {
            throw new IllegalArgumentException("Number support only: (-99999999999999.99 \uff5e 99999999999999.99)\uff01");
        }
        boolean bl3 = false;
        if (d2 < 0.0) {
            bl3 = true;
            d2 = -d2;
        }
        long l2 = Math.round(d2 * 100.0);
        int n2 = (int)(l2 % 10L);
        int n3 = (int)((l2 /= 10L) % 10L);
        l2 /= 10L;
        int[] nArray = new int[20];
        int n4 = 0;
        int n5 = 0;
        while (l2 != 0L) {
            int n6;
            nArray[n5] = n6 = (int)(l2 % 10000L);
            ++n4;
            l2 /= 10000L;
            ++n5;
        }
        n5 = 1;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n4; ++i2) {
            String string = NumberChineseFormatter.toChinese(nArray[i2], bl);
            if (i2 % 2 == 0) {
                n5 = StrUtil.isEmpty(string) ? 1 : 0;
            }
            if (i2 != 0) {
                if (i2 % 2 == 0) {
                    stringBuilder.insert(0, "\u4ebf");
                } else if ("".equals(string) && 0 == n5) {
                    stringBuilder.insert(0, "\u96f6");
                } else {
                    if (nArray[i2 - 1] < 1000 && nArray[i2 - 1] > 0) {
                        stringBuilder.insert(0, "\u96f6");
                    }
                    if (nArray[i2] > 0) {
                        stringBuilder.insert(0, "\u4e07");
                    }
                }
            }
            stringBuilder.insert(0, string);
        }
        if ("".equals(stringBuilder.toString())) {
            stringBuilder = new StringBuilder(stringArray[0]);
        }
        if (bl3) {
            stringBuilder.insert(0, "\u8d1f");
        }
        if (n2 != 0 || n3 != 0) {
            if (n2 == 0) {
                stringBuilder.append(bl2 ? "\u5143" : "\u70b9").append(stringArray[n3]).append(bl2 ? "\u89d2" : "");
            } else if (n3 == 0) {
                stringBuilder.append(bl2 ? "\u5143\u96f6" : "\u70b9\u96f6").append(stringArray[n2]).append(bl2 ? "\u5206" : "");
            } else {
                stringBuilder.append(bl2 ? "\u5143" : "\u70b9").append(stringArray[n3]).append(bl2 ? "\u89d2" : "").append(stringArray[n2]).append(bl2 ? "\u5206" : "");
            }
        } else if (bl2) {
            stringBuilder.append("\u5143\u6574");
        }
        return stringBuilder.toString();
    }

    public static String numberCharToChinese(char c2, boolean bl) {
        String[] stringArray = bl ? TRADITIONAL_DIGITS : SIMPLE_DIGITS;
        int n2 = c2 - 48;
        if (n2 < 0 || n2 >= stringArray.length) {
            return String.valueOf(c2);
        }
        return stringArray[n2];
    }

    private static String toChinese(int n2, boolean bl) {
        String[] stringArray = bl ? TRADITIONAL_DIGITS : SIMPLE_DIGITS;
        String[] stringArray2 = bl ? TRADITIONAL_UNITS : SIMPLE_UNITS;
        int n3 = n2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        int n4 = 0;
        while (n3 > 0) {
            int n5 = n3 % 10;
            if (n5 == 0) {
                if (!bl2) {
                    stringBuilder.insert(0, "\u96f6");
                }
                bl2 = true;
            } else {
                stringBuilder.insert(0, stringArray[n5] + stringArray2[n4]);
                bl2 = false;
            }
            n3 /= 10;
            ++n4;
        }
        return stringBuilder.toString();
    }
}

