/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert;

import com.ccb.core.bean.BeanUtil;
import com.ccb.core.convert.ConvertException;
import com.ccb.core.convert.Converter;
import com.ccb.core.convert.ConverterRegistry$SingletonHolder;
import com.ccb.core.convert.impl.ArrayConverter;
import com.ccb.core.convert.impl.AtomicBooleanConverter;
import com.ccb.core.convert.impl.AtomicIntegerArrayConverter;
import com.ccb.core.convert.impl.AtomicLongArrayConverter;
import com.ccb.core.convert.impl.AtomicReferenceConverter;
import com.ccb.core.convert.impl.BeanConverter;
import com.ccb.core.convert.impl.BooleanConverter;
import com.ccb.core.convert.impl.CalendarConverter;
import com.ccb.core.convert.impl.CharacterConverter;
import com.ccb.core.convert.impl.CharsetConverter;
import com.ccb.core.convert.impl.ClassConverter;
import com.ccb.core.convert.impl.CollectionConverter;
import com.ccb.core.convert.impl.CurrencyConverter;
import com.ccb.core.convert.impl.DateConverter;
import com.ccb.core.convert.impl.DurationConverter;
import com.ccb.core.convert.impl.EnumConverter;
import com.ccb.core.convert.impl.LocaleConverter;
import com.ccb.core.convert.impl.MapConverter;
import com.ccb.core.convert.impl.NumberConverter;
import com.ccb.core.convert.impl.OptionalConverter;
import com.ccb.core.convert.impl.PathConverter;
import com.ccb.core.convert.impl.PeriodConverter;
import com.ccb.core.convert.impl.PrimitiveConverter;
import com.ccb.core.convert.impl.ReferenceConverter;
import com.ccb.core.convert.impl.StackTraceElementConverter;
import com.ccb.core.convert.impl.StringConverter;
import com.ccb.core.convert.impl.TemporalAccessorConverter;
import com.ccb.core.convert.impl.TimeZoneConverter;
import com.ccb.core.convert.impl.URIConverter;
import com.ccb.core.convert.impl.URLConverter;
import com.ccb.core.convert.impl.UUIDConverter;
import com.ccb.core.date.DateTime;
import com.ccb.core.lang.TypeReference;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.ServiceLoaderUtil;
import com.ccb.core.util.TypeUtil;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;

public class ConverterRegistry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map defaultConverterMap;
    private volatile Map customConverterMap;

    public static ConverterRegistry getInstance() {
        return ConverterRegistry$SingletonHolder.access$000();
    }

    public ConverterRegistry() {
        this.defaultConverter();
        this.putCustomBySpi();
    }

    private void putCustomBySpi() {
        ServiceLoaderUtil.load(Converter.class).forEach(converter -> {
            try {
                Type type = TypeUtil.getTypeArgument(ClassUtil.getClass(converter));
                if (null != type) {
                    this.putCustom(type, (Converter)converter);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public ConverterRegistry putCustom(Type type, Class clazz) {
        return this.putCustom(type, (Converter)ReflectUtil.newInstance(clazz, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConverterRegistry putCustom(Type type, Converter converter) {
        if (null == this.customConverterMap) {
            ConverterRegistry converterRegistry = this;
            synchronized (converterRegistry) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new ConcurrentHashMap();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    public Converter getConverter(Type type, boolean bl) {
        Converter converter;
        if (bl) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public Converter getDefaultConverter(Type type) {
        return null == this.defaultConverterMap ? null : (Converter)this.defaultConverterMap.get(type);
    }

    public Converter getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : (Converter)this.customConverterMap.get(type);
    }

    public Object convert(Type type, Object object, Object object2, boolean bl) {
        Object object3;
        Converter converter;
        if (TypeUtil.isUnknown(type) && null == object2) {
            return object;
        }
        if (ObjectUtil.isNull(object)) {
            return object2;
        }
        if (TypeUtil.isUnknown(type)) {
            type = object2.getClass();
        }
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        if (null != (converter = this.getConverter(type, bl))) {
            return converter.convert(object, object2);
        }
        Class<?> clazz = TypeUtil.getClass(type);
        if (null == clazz) {
            if (null != object2) {
                clazz = object2.getClass();
            } else {
                return object;
            }
        }
        if (null != (object3 = this.convertSpecial(type, clazz, object, object2))) {
            return object3;
        }
        if (BeanUtil.isBean(clazz)) {
            return new BeanConverter(type).convert(object, object2);
        }
        throw new ConvertException("Can not Converter from [{}] to [{}]", object.getClass().getName(), type.getTypeName());
    }

    public Object convert(Type type, Object object, Object object2) {
        return this.convert(type, object, object2, true);
    }

    public Object convert(Type type, Object object) {
        return this.convert(type, object, null);
    }

    private Object convertSpecial(Type type, Class clazz, Object object, Object object2) {
        if (null == clazz) {
            return null;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            CollectionConverter collectionConverter = new CollectionConverter(type);
            return collectionConverter.convert(object, (Collection)object2);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            MapConverter mapConverter = new MapConverter(type);
            return mapConverter.convert(object, (Map)object2);
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        if (clazz.isEnum()) {
            return new EnumConverter(clazz).convert(object, object2);
        }
        if (clazz.isArray()) {
            ArrayConverter arrayConverter = new ArrayConverter(clazz);
            return arrayConverter.convert(object, object2);
        }
        return null;
    }

    private ConverterRegistry defaultConverter() {
        this.defaultConverterMap = new ConcurrentHashMap();
        this.defaultConverterMap.put(Integer.TYPE, new PrimitiveConverter(Integer.TYPE));
        this.defaultConverterMap.put(Long.TYPE, new PrimitiveConverter(Long.TYPE));
        this.defaultConverterMap.put(Byte.TYPE, new PrimitiveConverter(Byte.TYPE));
        this.defaultConverterMap.put(Short.TYPE, new PrimitiveConverter(Short.TYPE));
        this.defaultConverterMap.put(Float.TYPE, new PrimitiveConverter(Float.TYPE));
        this.defaultConverterMap.put(Double.TYPE, new PrimitiveConverter(Double.TYPE));
        this.defaultConverterMap.put(Character.TYPE, new PrimitiveConverter(Character.TYPE));
        this.defaultConverterMap.put(Boolean.TYPE, new PrimitiveConverter(Boolean.TYPE));
        this.defaultConverterMap.put(Number.class, new NumberConverter());
        this.defaultConverterMap.put(Integer.class, new NumberConverter(Integer.class));
        this.defaultConverterMap.put(AtomicInteger.class, new NumberConverter(AtomicInteger.class));
        this.defaultConverterMap.put(Long.class, new NumberConverter(Long.class));
        this.defaultConverterMap.put(AtomicLong.class, new NumberConverter(AtomicLong.class));
        this.defaultConverterMap.put(Byte.class, new NumberConverter(Byte.class));
        this.defaultConverterMap.put(Short.class, new NumberConverter(Short.class));
        this.defaultConverterMap.put(Float.class, new NumberConverter(Float.class));
        this.defaultConverterMap.put(Double.class, new NumberConverter(Double.class));
        this.defaultConverterMap.put(Character.class, new CharacterConverter());
        this.defaultConverterMap.put(Boolean.class, new BooleanConverter());
        this.defaultConverterMap.put(AtomicBoolean.class, new AtomicBooleanConverter());
        this.defaultConverterMap.put(BigDecimal.class, new NumberConverter(BigDecimal.class));
        this.defaultConverterMap.put(BigInteger.class, new NumberConverter(BigInteger.class));
        this.defaultConverterMap.put(CharSequence.class, new StringConverter());
        this.defaultConverterMap.put(String.class, new StringConverter());
        this.defaultConverterMap.put(URI.class, new URIConverter());
        this.defaultConverterMap.put(URL.class, new URLConverter());
        this.defaultConverterMap.put(Calendar.class, new CalendarConverter());
        this.defaultConverterMap.put(Date.class, new DateConverter(Date.class));
        this.defaultConverterMap.put(DateTime.class, new DateConverter(DateTime.class));
        this.defaultConverterMap.put(java.sql.Date.class, new DateConverter(java.sql.Date.class));
        this.defaultConverterMap.put(Time.class, new DateConverter(Time.class));
        this.defaultConverterMap.put(Timestamp.class, new DateConverter(Timestamp.class));
        this.defaultConverterMap.put(TemporalAccessor.class, new TemporalAccessorConverter(Instant.class));
        this.defaultConverterMap.put(Instant.class, new TemporalAccessorConverter(Instant.class));
        this.defaultConverterMap.put(LocalDateTime.class, new TemporalAccessorConverter(LocalDateTime.class));
        this.defaultConverterMap.put(LocalDate.class, new TemporalAccessorConverter(LocalDate.class));
        this.defaultConverterMap.put(LocalTime.class, new TemporalAccessorConverter(LocalTime.class));
        this.defaultConverterMap.put(ZonedDateTime.class, new TemporalAccessorConverter(ZonedDateTime.class));
        this.defaultConverterMap.put(OffsetDateTime.class, new TemporalAccessorConverter(OffsetDateTime.class));
        this.defaultConverterMap.put(OffsetTime.class, new TemporalAccessorConverter(OffsetTime.class));
        this.defaultConverterMap.put(Period.class, new PeriodConverter());
        this.defaultConverterMap.put(Duration.class, new DurationConverter());
        this.defaultConverterMap.put(WeakReference.class, new ReferenceConverter(WeakReference.class));
        this.defaultConverterMap.put(SoftReference.class, new ReferenceConverter(SoftReference.class));
        this.defaultConverterMap.put(AtomicReference.class, new AtomicReferenceConverter());
        this.defaultConverterMap.put(AtomicIntegerArray.class, new AtomicIntegerArrayConverter());
        this.defaultConverterMap.put(AtomicLongArray.class, new AtomicLongArrayConverter());
        this.defaultConverterMap.put(Class.class, new ClassConverter());
        this.defaultConverterMap.put(TimeZone.class, new TimeZoneConverter());
        this.defaultConverterMap.put(Locale.class, new LocaleConverter());
        this.defaultConverterMap.put(Charset.class, new CharsetConverter());
        this.defaultConverterMap.put(Path.class, new PathConverter());
        this.defaultConverterMap.put(Currency.class, new CurrencyConverter());
        this.defaultConverterMap.put(UUID.class, new UUIDConverter());
        this.defaultConverterMap.put(StackTraceElement.class, new StackTraceElementConverter());
        this.defaultConverterMap.put(Optional.class, new OptionalConverter());
        return this;
    }
}

