/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert;

import com.ccb.core.convert.BasicType;
import com.ccb.core.convert.ConverterRegistry;
import com.ccb.core.convert.NumberChineseFormatter;
import com.ccb.core.convert.NumberWordFormatter;
import com.ccb.core.convert.impl.CollectionConverter;
import com.ccb.core.convert.impl.EnumConverter;
import com.ccb.core.convert.impl.MapConverter;
import com.ccb.core.lang.Assert;
import com.ccb.core.lang.TypeReference;
import com.ccb.core.text.UnicodeUtil;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.HexUtil;
import com.ccb.core.util.StrUtil;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Convert {
    public static String toStr(Object object, String string) {
        return (String)Convert.convertQuietly(String.class, object, string);
    }

    public static String toStr(Object object) {
        return Convert.toStr(object, null);
    }

    public static String[] toStrArray(Object object) {
        return (String[])Convert.convert(String[].class, object);
    }

    public static Character toChar(Object object, Character c2) {
        return (Character)Convert.convertQuietly(Character.class, object, c2);
    }

    public static Character toChar(Object object) {
        return Convert.toChar(object, null);
    }

    public static Character[] toCharArray(Object object) {
        return (Character[])Convert.convert(Character[].class, object);
    }

    public static Byte toByte(Object object, Byte by) {
        return (Byte)Convert.convertQuietly(Byte.class, object, by);
    }

    public static Byte toByte(Object object) {
        return Convert.toByte(object, null);
    }

    public static Byte[] toByteArray(Object object) {
        return (Byte[])Convert.convert(Byte[].class, object);
    }

    public static byte[] toPrimitiveByteArray(Object object) {
        return (byte[])Convert.convert(byte[].class, object);
    }

    public static Short toShort(Object object, Short s2) {
        return (Short)Convert.convertQuietly(Short.class, object, s2);
    }

    public static Short toShort(Object object) {
        return Convert.toShort(object, null);
    }

    public static Short[] toShortArray(Object object) {
        return (Short[])Convert.convert(Short[].class, object);
    }

    public static Number toNumber(Object object, Number number) {
        return (Number)Convert.convertQuietly(Number.class, object, number);
    }

    public static Number toNumber(Object object) {
        return Convert.toNumber(object, null);
    }

    public static Number[] toNumberArray(Object object) {
        return (Number[])Convert.convert(Number[].class, object);
    }

    public static Integer toInt(Object object, Integer n2) {
        return (Integer)Convert.convertQuietly(Integer.class, object, n2);
    }

    public static Integer toInt(Object object) {
        return Convert.toInt(object, null);
    }

    public static Integer[] toIntArray(Object object) {
        return (Integer[])Convert.convert(Integer[].class, object);
    }

    public static Long toLong(Object object, Long l2) {
        return (Long)Convert.convertQuietly(Long.class, object, l2);
    }

    public static Long toLong(Object object) {
        return Convert.toLong(object, null);
    }

    public static Long[] toLongArray(Object object) {
        return (Long[])Convert.convert(Long[].class, object);
    }

    public static Double toDouble(Object object, Double d2) {
        return (Double)Convert.convertQuietly(Double.class, object, d2);
    }

    public static Double toDouble(Object object) {
        return Convert.toDouble(object, null);
    }

    public static Double[] toDoubleArray(Object object) {
        return (Double[])Convert.convert(Double[].class, object);
    }

    public static Float toFloat(Object object, Float f2) {
        return (Float)Convert.convertQuietly(Float.class, object, f2);
    }

    public static Float toFloat(Object object) {
        return Convert.toFloat(object, null);
    }

    public static Float[] toFloatArray(Object object) {
        return (Float[])Convert.convert(Float[].class, object);
    }

    public static Boolean toBool(Object object, Boolean bl) {
        return (Boolean)Convert.convertQuietly(Boolean.class, object, bl);
    }

    public static Boolean toBool(Object object) {
        return Convert.toBool(object, null);
    }

    public static Boolean[] toBooleanArray(Object object) {
        return (Boolean[])Convert.convert(Boolean[].class, object);
    }

    public static BigInteger toBigInteger(Object object, BigInteger bigInteger) {
        return (BigInteger)Convert.convertQuietly(BigInteger.class, object, bigInteger);
    }

    public static BigInteger toBigInteger(Object object) {
        return Convert.toBigInteger(object, null);
    }

    public static BigDecimal toBigDecimal(Object object, BigDecimal bigDecimal) {
        return (BigDecimal)Convert.convertQuietly(BigDecimal.class, object, bigDecimal);
    }

    public static BigDecimal toBigDecimal(Object object) {
        return Convert.toBigDecimal(object, null);
    }

    public static Date toDate(Object object, Date date) {
        return (Date)Convert.convertQuietly(Date.class, object, date);
    }

    public static LocalDateTime toLocalDateTime(Object object, LocalDateTime localDateTime) {
        return (LocalDateTime)Convert.convertQuietly(LocalDateTime.class, object, localDateTime);
    }

    public static LocalDateTime toLocalDateTime(Object object) {
        return Convert.toLocalDateTime(object, null);
    }

    public static Date toInstant(Object object, Date date) {
        return (Date)Convert.convertQuietly(Instant.class, object, date);
    }

    public static Date toDate(Object object) {
        return Convert.toDate(object, null);
    }

    public static Enum toEnum(Class clazz, Object object, Enum enum_) {
        return (Enum)new EnumConverter(clazz).convertQuietly(object, enum_);
    }

    public static Enum toEnum(Class clazz, Object object) {
        return Convert.toEnum(clazz, object, null);
    }

    public static Collection toCollection(Class clazz, Class clazz2, Object object) {
        return new CollectionConverter(clazz, clazz2).convert(object, null);
    }

    public static List toList(Object object) {
        return (List)Convert.convert(List.class, object);
    }

    public static List toList(Class clazz, Object object) {
        return (List)Convert.toCollection(ArrayList.class, clazz, object);
    }

    public static Map toMap(Class clazz, Class clazz2, Object object) {
        return (Map)new MapConverter((Type)((Object)HashMap.class), clazz, clazz2).convert(object, null);
    }

    public static Object convertByClassName(String string, Object object) {
        return Convert.convert(ClassUtil.loadClass(string), object);
    }

    public static Object convert(Class clazz, Object object) {
        return Convert.convert((Type)clazz, object);
    }

    public static Object convert(TypeReference typeReference, Object object) {
        return Convert.convert(typeReference.getType(), object, null);
    }

    public static Object convert(Type type, Object object) {
        return Convert.convert(type, object, null);
    }

    public static Object convert(Class clazz, Object object, Object object2) {
        return Convert.convert((Type)clazz, object, object2);
    }

    public static Object convert(Type type, Object object, Object object2) {
        return Convert.convertWithCheck(type, object, object2, false);
    }

    public static Object convertQuietly(Type type, Object object) {
        return Convert.convertQuietly(type, object, null);
    }

    public static Object convertQuietly(Type type, Object object, Object object2) {
        return Convert.convertWithCheck(type, object, object2, true);
    }

    public static Object convertWithCheck(Type type, Object object, Object object2, boolean bl) {
        ConverterRegistry converterRegistry = ConverterRegistry.getInstance();
        try {
            return converterRegistry.convert(type, object, object2);
        }
        catch (Exception exception) {
            if (bl) {
                return object2;
            }
            throw exception;
        }
    }

    public static String toSBC(String string) {
        return Convert.toSBC(string, null);
    }

    public static String toSBC(String string, Set set) {
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (null != set && set.contains(Character.valueOf(cArray[i2]))) continue;
            if (cArray[i2] == ' ') {
                cArray[i2] = 12288;
                continue;
            }
            if (cArray[i2] >= '\u007f') continue;
            cArray[i2] = (char)(cArray[i2] + 65248);
        }
        return new String(cArray);
    }

    public static String toDBC(String string) {
        return Convert.toDBC(string, null);
    }

    public static String toDBC(String string, Set set) {
        if (StrUtil.isBlank(string)) {
            return string;
        }
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (null != set && set.contains(Character.valueOf(cArray[i2]))) continue;
            if (cArray[i2] == '\u3000' || cArray[i2] == '\u00a0' || cArray[i2] == '\u2007' || cArray[i2] == '\u202f') {
                cArray[i2] = 32;
                continue;
            }
            if (cArray[i2] <= '\uff00' || cArray[i2] >= '\uff5f') continue;
            cArray[i2] = (char)(cArray[i2] - 65248);
        }
        return new String(cArray);
    }

    public static String toHex(String string, Charset charset) {
        return HexUtil.encodeHexStr(string, charset);
    }

    public static String toHex(byte[] byArray) {
        return HexUtil.encodeHexStr(byArray);
    }

    public static byte[] hexToBytes(String string) {
        return HexUtil.decodeHex(string.toCharArray());
    }

    public static String hexStrToStr(String string, Charset charset) {
        return Convert.hexToStr(string, charset);
    }

    public static String hexToStr(String string, Charset charset) {
        return HexUtil.decodeHexStr(string, charset);
    }

    public static String strToUnicode(String string) {
        return UnicodeUtil.toUnicode(string);
    }

    public static String unicodeToStr(String string) {
        return UnicodeUtil.toString(string);
    }

    public static String convertCharset(String string, String string2, String string3) {
        if (StrUtil.hasBlank(string, string2, string3)) {
            return string;
        }
        return CharsetUtil.convert(string, string2, string3);
    }

    public static long convertTime(long l2, TimeUnit timeUnit, TimeUnit timeUnit2) {
        Assert.notNull((Object)timeUnit, "sourceUnit is null !", new Object[0]);
        Assert.notNull((Object)timeUnit2, "destUnit is null !", new Object[0]);
        return timeUnit2.convert(l2, timeUnit);
    }

    public static Class wrap(Class clazz) {
        return BasicType.wrap(clazz);
    }

    public static Class unWrap(Class clazz) {
        return BasicType.unWrap(clazz);
    }

    public static String numberToWord(Number number) {
        return NumberWordFormatter.format(number);
    }

    public static String numberToChinese(double d2, boolean bl) {
        return NumberChineseFormatter.format(d2, bl);
    }

    public static String digitToChinese(Number number) {
        if (null == number) {
            return "\u96f6";
        }
        return NumberChineseFormatter.format(number.doubleValue(), true, true);
    }

    public static byte intToByte(int n2) {
        return (byte)n2;
    }

    public static int byteToUnsignedInt(byte by) {
        return by & 0xFF;
    }

    public static short bytesToShort(byte[] byArray) {
        return (short)(byArray[1] & 0xFF | (byArray[0] & 0xFF) << 8);
    }

    public static byte[] shortToBytes(short s2) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(s2 & 0xFF);
        byArray[0] = (byte)(s2 >> 8 & 0xFF);
        return byArray;
    }

    public static int bytesToInt(byte[] byArray) {
        return byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | (byArray[0] & 0xFF) << 24;
    }

    public static byte[] intToBytes(int n2) {
        return new byte[]{(byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
    }

    public static byte[] longToBytes(long l2) {
        byte[] byArray = new byte[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            byArray[i2] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        return byArray;
    }

    public static long bytesToLong(byte[] byArray) {
        long l2 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            l2 <<= 8;
            l2 |= (long)(byArray[i2] & 0xFF);
        }
        return l2;
    }
}

