/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.comparator;

import com.ccb.core.lang.Chain;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ComparatorChain
implements Chain,
Serializable,
Comparator {
    private static final long serialVersionUID = -2426725788913962429L;
    private final List chain;
    private final BitSet orderingBits;
    private boolean lock = false;

    public static ComparatorChain of(Comparator comparator) {
        return ComparatorChain.of(comparator, false);
    }

    public static ComparatorChain of(Comparator comparator, boolean bl) {
        return new ComparatorChain(comparator, bl);
    }

    public static ComparatorChain of(Comparator ... comparatorArray) {
        return ComparatorChain.of(Arrays.asList(comparatorArray));
    }

    public static ComparatorChain of(List list) {
        return new ComparatorChain(list);
    }

    public static ComparatorChain of(List list, BitSet bitSet) {
        return new ComparatorChain(list, bitSet);
    }

    public ComparatorChain() {
        this(new ArrayList(), new BitSet());
    }

    public ComparatorChain(Comparator comparator) {
        this(comparator, false);
    }

    public ComparatorChain(Comparator comparator, boolean bl) {
        this.chain = new ArrayList(1);
        this.chain.add(comparator);
        this.orderingBits = new BitSet(1);
        if (bl) {
            this.orderingBits.set(0);
        }
    }

    public ComparatorChain(List list) {
        this(list, new BitSet(list.size()));
    }

    public ComparatorChain(List list, BitSet bitSet) {
        this.chain = list;
        this.orderingBits = bitSet;
    }

    public ComparatorChain addComparator(Comparator comparator) {
        return this.addComparator(comparator, false);
    }

    public ComparatorChain addComparator(Comparator comparator, boolean bl) {
        this.checkLocked();
        this.chain.add(comparator);
        if (bl) {
            this.orderingBits.set(this.chain.size() - 1);
        }
        return this;
    }

    public ComparatorChain setComparator(int n2, Comparator comparator) {
        return this.setComparator(n2, comparator, false);
    }

    public ComparatorChain setComparator(int n2, Comparator comparator, boolean bl) {
        this.checkLocked();
        this.chain.set(n2, comparator);
        if (bl) {
            this.orderingBits.set(n2);
        } else {
            this.orderingBits.clear(n2);
        }
        return this;
    }

    public ComparatorChain setForwardSort(int n2) {
        this.checkLocked();
        this.orderingBits.clear(n2);
        return this;
    }

    public ComparatorChain setReverseSort(int n2) {
        this.checkLocked();
        this.orderingBits.set(n2);
        return this;
    }

    public int size() {
        return this.chain.size();
    }

    public boolean isLocked() {
        return this.lock;
    }

    public Iterator iterator() {
        return this.chain.iterator();
    }

    public ComparatorChain addChain(Comparator comparator) {
        return this.addComparator(comparator);
    }

    public int compare(Object object, Object object2) {
        if (!this.lock) {
            this.checkChainIntegrity();
            this.lock = true;
        }
        Iterator iterator = this.chain.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Comparator comparator = (Comparator)iterator.next();
            int n3 = comparator.compare(object, object2);
            if (n3 != 0) {
                if (this.orderingBits.get(n2)) {
                    n3 = n3 > 0 ? -1 : 1;
                }
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    public int hashCode() {
        int n2 = 0;
        if (null != this.chain) {
            n2 ^= this.chain.hashCode();
        }
        if (null != this.orderingBits) {
            n2 ^= this.orderingBits.hashCode();
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (object.getClass().equals(this.getClass())) {
            ComparatorChain comparatorChain = (ComparatorChain)object;
            return Objects.equals(this.orderingBits, comparatorChain.orderingBits) && this.chain.equals(comparatorChain.chain);
        }
        return false;
    }

    private void checkLocked() {
        if (this.lock) {
            throw new UnsupportedOperationException("Comparator ordering cannot be changed after the first comparison is performed");
        }
    }

    private void checkChainIntegrity() {
        if (this.chain.size() == 0) {
            throw new UnsupportedOperationException("ComparatorChains must contain at least one Comparator");
        }
    }
}

