/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.collection;

import com.ccb.core.collection.IterUtil;
import com.ccb.core.collection.SpliteratorUtil;
import com.ccb.core.lang.Assert;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class TransCollection
extends AbstractCollection {
    private final Collection fromCollection;
    private final Function function;

    public TransCollection(Collection collection, Function function) {
        this.fromCollection = (Collection)Assert.notNull(collection);
        this.function = (Function)Assert.notNull(function);
    }

    @Override
    public Iterator iterator() {
        return IterUtil.trans(this.fromCollection.iterator(), this.function);
    }

    @Override
    public void clear() {
        this.fromCollection.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.fromCollection.isEmpty();
    }

    @Override
    public void forEach(Consumer consumer) {
        Assert.notNull(consumer);
        this.fromCollection.forEach((? super T object) -> consumer.accept(this.function.apply(object)));
    }

    @Override
    public boolean removeIf(Predicate predicate) {
        Assert.notNull(predicate);
        return this.fromCollection.removeIf((? super E object) -> predicate.test(this.function.apply(object)));
    }

    @Override
    public Spliterator spliterator() {
        return SpliteratorUtil.trans(this.fromCollection.spliterator(), this.function);
    }

    @Override
    public int size() {
        return this.fromCollection.size();
    }
}

