/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.collection;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.comparator.PinyinComparator;
import com.ccb.core.comparator.PropertyComparator;
import com.ccb.core.convert.Convert;
import com.ccb.core.lang.Editor;
import com.ccb.core.lang.Matcher;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.PageUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ListUtil {
    public static List list(boolean bl) {
        return bl ? new LinkedList() : new ArrayList();
    }

    public static List list(boolean bl, Object ... objectArray) {
        if (ArrayUtil.isEmpty(objectArray)) {
            return ListUtil.list(bl);
        }
        AbstractList abstractList = bl ? new LinkedList() : new ArrayList(objectArray.length);
        Collections.addAll(abstractList, objectArray);
        return abstractList;
    }

    public static List list(boolean bl, Collection collection) {
        if (null == collection) {
            return ListUtil.list(bl);
        }
        return bl ? new LinkedList(collection) : new ArrayList(collection);
    }

    public static List list(boolean bl, Iterable iterable) {
        if (null == iterable) {
            return ListUtil.list(bl);
        }
        return ListUtil.list(bl, iterable.iterator());
    }

    public static List list(boolean bl, Iterator iterator) {
        List list = ListUtil.list(bl);
        if (null != iterator) {
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }
        return list;
    }

    public static List list(boolean bl, Enumeration enumeration) {
        List list = ListUtil.list(bl);
        if (null != enumeration) {
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
        }
        return list;
    }

    public static ArrayList toList(Object ... objectArray) {
        return (ArrayList)ListUtil.list(false, objectArray);
    }

    public static LinkedList toLinkedList(Object ... objectArray) {
        return (LinkedList)ListUtil.list(true, objectArray);
    }

    public static List of(Object ... objectArray) {
        if (ArrayUtil.isEmpty(objectArray)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(ListUtil.toList(objectArray));
    }

    public static CopyOnWriteArrayList toCopyOnWriteArrayList(Collection collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList(collection);
    }

    public static ArrayList toList(Collection collection) {
        return (ArrayList)ListUtil.list(false, collection);
    }

    public static ArrayList toList(Iterable iterable) {
        return (ArrayList)ListUtil.list(false, iterable);
    }

    public static ArrayList toList(Iterator iterator) {
        return (ArrayList)ListUtil.list(false, iterator);
    }

    public static ArrayList toList(Enumeration enumeration) {
        return (ArrayList)ListUtil.list(false, enumeration);
    }

    public static List page(int n2, int n3, List list) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList(0);
        }
        int n4 = list.size();
        if (n4 <= n3) {
            if (n2 < 1) {
                return Collections.unmodifiableList(list);
            }
            return new ArrayList(0);
        }
        if ((long)n2 * (long)n3 > (long)n4) {
            return new ArrayList(0);
        }
        int[] nArray = PageUtil.transToStartEnd(n2, n3);
        if (nArray[1] > n4) {
            nArray[1] = n4;
        }
        return list.subList(nArray[0], nArray[1]);
    }

    public static List sort(List list, Comparator comparator) {
        list.sort(comparator);
        return list;
    }

    public static List sortByProperty(List list, String string) {
        return ListUtil.sort(list, new PropertyComparator(string));
    }

    public static List sortByPinyin(List list) {
        return ListUtil.sort(list, new PinyinComparator());
    }

    public static List reverse(List list) {
        Collections.reverse(list);
        return list;
    }

    public static List reverseNew(List list) {
        List list2 = (List)ObjectUtil.clone(list);
        return ListUtil.reverse(list2);
    }

    public static List setOrAppend(List list, int n2, Object object) {
        if (n2 < list.size()) {
            list.set(n2, object);
        } else {
            list.add(object);
        }
        return list;
    }

    public static List sub(List list, int n2, int n3) {
        return ListUtil.sub(list, n2, n3, 1);
    }

    public static List sub(List list, int n2, int n3, int n4) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new ArrayList(0);
        }
        int n5 = list.size();
        if (n2 < 0) {
            n2 += n5;
        }
        if (n3 < 0) {
            n3 += n5;
        }
        if (n2 == n5) {
            return new ArrayList(0);
        }
        if (n2 > n3) {
            int n6 = n2;
            n2 = n3;
            n3 = n6;
        }
        if (n3 > n5) {
            if (n2 >= n5) {
                return new ArrayList(0);
            }
            n3 = n5;
        }
        if (n4 <= 1) {
            return list.subList(n2, n3);
        }
        ArrayList arrayList = new ArrayList();
        for (int i2 = n2; i2 < n3; i2 += n4) {
            arrayList.add(list.get(i2));
        }
        return arrayList;
    }

    public static List filter(List list, Editor editor) {
        if (null == list || null == editor) {
            return list;
        }
        AbstractList abstractList = list instanceof LinkedList ? new LinkedList() : new ArrayList(list.size());
        for (Object e2 : list) {
            Object object = editor.edit(e2);
            if (null == object) continue;
            abstractList.add(object);
        }
        return abstractList;
    }

    public static int[] indexOfAll(List list, Matcher matcher) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (null != list) {
            int n2 = 0;
            for (Object e2 : list) {
                if (null == matcher || matcher.match(e2)) {
                    arrayList.add(n2);
                }
                ++n2;
            }
        }
        return (int[])Convert.convert(int[].class, arrayList);
    }

    public static List unmodifiable(List list) {
        if (null == list) {
            return null;
        }
        return Collections.unmodifiableList(list);
    }

    public static List empty() {
        return Collections.emptyList();
    }

    public static List split(List list, int n2) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        int n3 = list.size();
        ArrayList arrayList = new ArrayList(n3 / n2 + 1);
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; i2 += n2) {
            arrayList.add(list.subList(n4, i2));
            n4 = i2;
        }
        if (n4 < n3) {
            arrayList.add(list.subList(n4, n3));
        }
        return arrayList;
    }
}

