/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.collection;

import com.ccb.core.collection.CopiedIter;
import com.ccb.core.collection.EnumerationIter;
import com.ccb.core.collection.TransIter;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.lang.Filter;
import com.ccb.core.lang.func.Func1;
import com.ccb.core.map.MapUtil;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class IterUtil {
    public static boolean isEmpty(Iterable iterable) {
        return null == iterable || IterUtil.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator iterator) {
        return null == iterator || false == iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterable iterable) {
        return null != iterable && IterUtil.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator iterator) {
        return null != iterator && iterator.hasNext();
    }

    public static boolean hasNull(Iterable iterable) {
        return IterUtil.hasNull(null == iterable ? null : iterable.iterator());
    }

    public static boolean hasNull(Iterator iterator) {
        if (null == iterator) {
            return true;
        }
        while (iterator.hasNext()) {
            if (null != iterator.next()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Iterable iterable) {
        return IterUtil.isAllNull(null == iterable ? null : iterable.iterator());
    }

    public static boolean isAllNull(Iterator iterator) {
        if (null == iterator) {
            return true;
        }
        while (iterator.hasNext()) {
            if (null == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public static Map countMap(Iterable iterable) {
        return IterUtil.countMap(null == iterable ? null : iterable.iterator());
    }

    public static Map countMap(Iterator iterator) {
        HashMap hashMap = new HashMap();
        if (null != iterator) {
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                Integer n2 = (Integer)hashMap.get(e2);
                if (null == n2) {
                    hashMap.put(e2, 1);
                    continue;
                }
                hashMap.put(e2, n2 + 1);
            }
        }
        return hashMap;
    }

    public static Map fieldValueMap(Iterable iterable, String string) {
        return IterUtil.fieldValueMap(null == iterable ? null : iterable.iterator(), string);
    }

    public static Map fieldValueMap(Iterator iterator, String string) {
        return IterUtil.toMap(iterator, new HashMap(), (Object object) -> ReflectUtil.getFieldValue(object, string));
    }

    public static Map fieldValueAsMap(Iterable iterable, String string, String string2) {
        return IterUtil.fieldValueAsMap(null == iterable ? null : iterable.iterator(), string, string2);
    }

    public static Map fieldValueAsMap(Iterator iterator, String string, String string2) {
        return IterUtil.toMap(iterator, new HashMap(), (Object object) -> ReflectUtil.getFieldValue(object, string), (Object object) -> ReflectUtil.getFieldValue(object, string2));
    }

    public static List fieldValueList(Iterable iterable, String string) {
        return IterUtil.fieldValueList(null == iterable ? null : iterable.iterator(), string);
    }

    public static List fieldValueList(Iterator iterator, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (null != iterator) {
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                arrayList.add(ReflectUtil.getFieldValue(e2, string));
            }
        }
        return arrayList;
    }

    public static String join(Iterable iterable, CharSequence charSequence) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.join(iterable.iterator(), charSequence);
    }

    public static String join(Iterable iterable, CharSequence charSequence, String string, String string2) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.join(iterable.iterator(), charSequence, string, string2);
    }

    public static String join(Iterator iterator, CharSequence charSequence) {
        return IterUtil.join(iterator, charSequence, null, null);
    }

    public static String join(Iterator iterator, CharSequence charSequence, String string, String string2) {
        if (null == iterator) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            Object e2 = iterator.next();
            if (ArrayUtil.isArray(e2)) {
                stringBuilder.append(ArrayUtil.join(ArrayUtil.wrap(e2), charSequence, string, string2));
                continue;
            }
            if (e2 instanceof Iterable) {
                stringBuilder.append(IterUtil.join((Iterable)e2, charSequence, string, string2));
                continue;
            }
            if (e2 instanceof Iterator) {
                stringBuilder.append(IterUtil.join((Iterator)e2, charSequence, string, string2));
                continue;
            }
            stringBuilder.append(StrUtil.wrap(String.valueOf(e2), string, string2));
        }
        return stringBuilder.toString();
    }

    public static HashMap toMap(Iterable iterable) {
        HashMap hashMap = new HashMap();
        if (IterUtil.isNotEmpty(iterable)) {
            for (Map.Entry entry : iterable) {
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    public static Map toMap(Iterable iterable, Iterable iterable2) {
        return IterUtil.toMap(iterable, iterable2, false);
    }

    public static Map toMap(Iterable iterable, Iterable iterable2, boolean bl) {
        return IterUtil.toMap(null == iterable ? null : iterable.iterator(), null == iterable2 ? null : iterable2.iterator(), bl);
    }

    public static Map toMap(Iterator iterator, Iterator iterator2) {
        return IterUtil.toMap(iterator, iterator2, false);
    }

    public static Map toMap(Iterator iterator, Iterator iterator2, boolean bl) {
        HashMap hashMap = MapUtil.newHashMap(bl);
        if (IterUtil.isNotEmpty(iterator)) {
            while (iterator.hasNext()) {
                hashMap.put(iterator.next(), null != iterator2 && iterator2.hasNext() ? (Object)iterator2.next() : null);
            }
        }
        return hashMap;
    }

    public static Map toListMap(Iterable iterable, Function function) {
        return IterUtil.toListMap(iterable, function, object -> object);
    }

    public static Map toListMap(Iterable iterable, Function function, Function function2) {
        return IterUtil.toListMap(MapUtil.newHashMap(), iterable, function, function2);
    }

    public static Map toListMap(Map map, Iterable iterable, Function function, Function function2) {
        if (null == map) {
            map = MapUtil.newHashMap();
        }
        if (ObjectUtil.isNull(iterable)) {
            return map;
        }
        for (Object t2 : iterable) {
            map.computeIfAbsent(function.apply(t2), object -> new ArrayList()).add(function2.apply(t2));
        }
        return map;
    }

    public static Map toMap(Iterable iterable, Function function) {
        return IterUtil.toMap(iterable, function, (T object) -> object);
    }

    public static Map toMap(Iterable iterable, Function function, Function function2) {
        return IterUtil.toMap(MapUtil.newHashMap(), iterable, function, function2);
    }

    public static Map toMap(Map map, Iterable iterable, Function function, Function function2) {
        if (null == map) {
            map = MapUtil.newHashMap();
        }
        if (ObjectUtil.isNull(iterable)) {
            return map;
        }
        for (Object t2 : iterable) {
            map.put(function.apply(t2), function2.apply(t2));
        }
        return map;
    }

    public static List toList(Iterable iterable) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.toList(iterable.iterator());
    }

    public static List toList(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static Iterator asIterator(Enumeration enumeration) {
        return new EnumerationIter(enumeration);
    }

    public static Iterable asIterable(Iterator iterator) {
        return () -> iterator;
    }

    public static Object getFirst(Iterable iterable) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.getFirst(iterable.iterator());
    }

    public static Object getFirst(Iterator iterator) {
        if (null != iterator && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static Class getElementType(Iterable iterable) {
        if (null != iterable) {
            Iterator iterator = iterable.iterator();
            return IterUtil.getElementType(iterator);
        }
        return null;
    }

    public static Class getElementType(Iterator iterator) {
        Object e2;
        CopiedIter copiedIter = new CopiedIter(iterator);
        if (copiedIter.hasNext() && null != (e2 = copiedIter.next())) {
            return e2.getClass();
        }
        return null;
    }

    public static Iterable filter(Iterable iterable, Filter filter) {
        if (null == iterable) {
            return null;
        }
        IterUtil.filter(iterable.iterator(), filter);
        return iterable;
    }

    public static Iterator filter(Iterator iterator, Filter filter) {
        if (null == iterator || null == filter) {
            return iterator;
        }
        while (iterator.hasNext()) {
            if (filter.accept(iterator.next())) continue;
            iterator.remove();
        }
        return iterator;
    }

    public static Map toMap(Iterator iterator, Map map, Func1 func1) {
        return IterUtil.toMap(iterator, map, func1, (Object object) -> object);
    }

    public static Map toMap(Iterator iterator, Map map, Func1 func1, Func1 func12) {
        if (null == iterator) {
            return map;
        }
        if (null == map) {
            map = MapUtil.newHashMap(true);
        }
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            try {
                map.put(func1.call(e2), func12.call(e2));
            }
            catch (Exception exception) {
                throw new UtilException(exception);
            }
        }
        return map;
    }

    public static Iterator empty() {
        return Collections.emptyIterator();
    }

    public static Iterator trans(Iterator iterator, Function function) {
        return new TransIter(iterator, function);
    }
}

