/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashSet
extends AbstractSet
implements Serializable {
    private static final long serialVersionUID = 7997886765361607470L;
    private static final Boolean PRESENT = true;
    private final ConcurrentHashMap map;

    public ConcurrentHashSet() {
        this.map = new ConcurrentHashMap();
    }

    public ConcurrentHashSet(int n2) {
        this.map = new ConcurrentHashMap(n2);
    }

    public ConcurrentHashSet(int n2, float f2) {
        this.map = new ConcurrentHashMap(n2, f2);
    }

    public ConcurrentHashSet(int n2, float f2, int n3) {
        this.map = new ConcurrentHashMap(n2, f2, n3);
    }

    public ConcurrentHashSet(Iterable iterable) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            this.map = new ConcurrentHashMap((int)((float)collection.size() / 0.75f));
            this.addAll(collection);
        } else {
            this.map = new ConcurrentHashMap();
            for (Object t2 : iterable) {
                this.add(t2);
            }
        }
    }

    @Override
    public Iterator iterator() {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean add(Object object) {
        return this.map.put(object, PRESENT) == null;
    }

    @Override
    public boolean remove(Object object) {
        return PRESENT.equals(this.map.remove(object));
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

