/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.collection;

import com.ccb.core.collection.ArrayIter;
import com.ccb.core.collection.CollUtil$1;
import com.ccb.core.collection.CollUtil$Consumer;
import com.ccb.core.collection.CollUtil$KVConsumer;
import com.ccb.core.collection.EnumerationIter;
import com.ccb.core.collection.IterUtil;
import com.ccb.core.collection.IteratorEnumeration;
import com.ccb.core.collection.ListUtil;
import com.ccb.core.collection.TransCollection;
import com.ccb.core.comparator.CompareUtil;
import com.ccb.core.comparator.PinyinComparator;
import com.ccb.core.comparator.PropertyComparator;
import com.ccb.core.convert.Convert;
import com.ccb.core.convert.ConverterRegistry;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.lang.Editor;
import com.ccb.core.lang.Filter;
import com.ccb.core.lang.Matcher;
import com.ccb.core.lang.func.Func1;
import com.ccb.core.lang.hash.Hash32;
import com.ccb.core.map.MapUtil;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;
import java.util.function.Predicate;

public class CollUtil {
    public static Set emptyIfNull(Set set) {
        return null == set ? Collections.emptySet() : set;
    }

    public static List emptyIfNull(List list) {
        return null == list ? Collections.emptyList() : list;
    }

    public static Collection union(Collection collection, Collection collection2) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList(collection2);
        }
        if (CollUtil.isEmpty(collection2)) {
            return new ArrayList(collection);
        }
        ArrayList arrayList = new ArrayList(Math.max(collection.size(), collection2.size()));
        Map map = CollUtil.countMap(collection);
        Map map2 = CollUtil.countMap(collection2);
        HashSet hashSet = CollUtil.newHashSet(collection2);
        hashSet.addAll(collection);
        for (Object e2 : hashSet) {
            int n2 = Math.max(Convert.toInt(map.get(e2), 0), Convert.toInt(map2.get(e2), 0));
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    public static Collection union(Collection collection, Collection collection2, Collection ... collectionArray) {
        Collection collection3 = CollUtil.union(collection, collection2);
        for (Collection collection4 : collectionArray) {
            collection3 = CollUtil.union(collection3, collection4);
        }
        return collection3;
    }

    public static Set unionDistinct(Collection collection, Collection collection2, Collection ... collectionArray) {
        LinkedHashSet linkedHashSet = CollUtil.isEmpty(collection) ? new LinkedHashSet() : new LinkedHashSet(collection);
        if (CollUtil.isNotEmpty(collection2)) {
            linkedHashSet.addAll(collection2);
        }
        if (ArrayUtil.isNotEmpty(collectionArray)) {
            for (Collection collection3 : collectionArray) {
                linkedHashSet.addAll(collection3);
            }
        }
        return linkedHashSet;
    }

    public static List unionAll(Collection collection, Collection collection2, Collection ... collectionArray) {
        ArrayList arrayList = CollUtil.isEmpty(collection) ? new ArrayList() : new ArrayList(collection);
        if (CollUtil.isNotEmpty(collection2)) {
            arrayList.addAll(collection2);
        }
        if (ArrayUtil.isNotEmpty(collectionArray)) {
            for (Collection collection3 : collectionArray) {
                arrayList.addAll(collection3);
            }
        }
        return arrayList;
    }

    public static Collection intersection(Collection collection, Collection collection2) {
        if (CollUtil.isNotEmpty(collection) && CollUtil.isNotEmpty(collection2)) {
            ArrayList arrayList = new ArrayList(Math.min(collection.size(), collection2.size()));
            Map map = CollUtil.countMap(collection);
            Map map2 = CollUtil.countMap(collection2);
            HashSet hashSet = CollUtil.newHashSet(collection2);
            for (Object e2 : hashSet) {
                int n2 = Math.min(Convert.toInt(map.get(e2), 0), Convert.toInt(map2.get(e2), 0));
                for (int i2 = 0; i2 < n2; ++i2) {
                    arrayList.add(e2);
                }
            }
            return arrayList;
        }
        return new ArrayList();
    }

    public static Collection intersection(Collection collection, Collection collection2, Collection ... collectionArray) {
        Collection collection3 = CollUtil.intersection(collection, collection2);
        if (CollUtil.isEmpty(collection3)) {
            return collection3;
        }
        for (Collection collection4 : collectionArray) {
            if (!CollUtil.isEmpty(collection3 = CollUtil.intersection(collection3, collection4))) continue;
            return collection3;
        }
        return collection3;
    }

    public static Set intersectionDistinct(Collection collection, Collection collection2, Collection ... collectionArray) {
        if (CollUtil.isEmpty(collection) || CollUtil.isEmpty(collection2)) {
            return new LinkedHashSet();
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(collection);
        if (ArrayUtil.isNotEmpty(collectionArray)) {
            for (Collection collection3 : collectionArray) {
                if (!CollUtil.isNotEmpty(collection3)) {
                    return new LinkedHashSet();
                }
                linkedHashSet.retainAll(collection3);
            }
        }
        linkedHashSet.retainAll(collection2);
        return linkedHashSet;
    }

    public static Collection disjunction(Collection collection, Collection collection2) {
        if (CollUtil.isEmpty(collection)) {
            return collection2;
        }
        if (CollUtil.isEmpty(collection2)) {
            return collection;
        }
        ArrayList arrayList = new ArrayList();
        Map map = CollUtil.countMap(collection);
        Map map2 = CollUtil.countMap(collection2);
        HashSet hashSet = CollUtil.newHashSet(collection2);
        hashSet.addAll(collection);
        for (Object e2 : hashSet) {
            int n2 = Math.abs(Convert.toInt(map.get(e2), 0) - Convert.toInt(map2.get(e2), 0));
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    public static Collection subtract(Collection collection, Collection collection2) {
        Collection collection3 = (Collection)ObjectUtil.clone(collection);
        collection3.removeAll(collection2);
        return collection3;
    }

    public static List subtractToList(Collection collection, Collection collection2) {
        if (CollUtil.isEmpty(collection)) {
            return ListUtil.empty();
        }
        if (CollUtil.isEmpty(collection2)) {
            return ListUtil.list(true, collection);
        }
        LinkedList linkedList = new LinkedList();
        HashSet hashSet = new HashSet(collection2);
        for (Object e2 : collection) {
            if (hashSet.contains(e2)) continue;
            linkedList.add(e2);
        }
        return linkedList;
    }

    public static boolean contains(Collection collection, Object object) {
        return CollUtil.isNotEmpty(collection) && collection.contains(object);
    }

    public static boolean contains(Collection collection, Predicate predicate) {
        if (CollUtil.isEmpty(collection)) {
            return false;
        }
        for (Object e2 : collection) {
            if (!predicate.test(e2)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(Collection collection, Collection collection2) {
        if (CollUtil.isEmpty(collection) || CollUtil.isEmpty(collection2)) {
            return false;
        }
        if (collection.size() < collection2.size()) {
            for (Object e2 : collection) {
                if (!collection2.contains(e2)) continue;
                return true;
            }
        } else {
            for (Object e3 : collection2) {
                if (!collection.contains(e3)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAll(Collection collection, Collection collection2) {
        if (CollUtil.isEmpty(collection)) {
            return CollUtil.isEmpty(collection2);
        }
        if (CollUtil.isEmpty(collection2)) {
            return true;
        }
        if (collection.size() < collection2.size()) {
            return false;
        }
        for (Object e2 : collection2) {
            if (collection.contains(e2)) continue;
            return false;
        }
        return true;
    }

    public static Map countMap(Iterable iterable) {
        return IterUtil.countMap(null == iterable ? null : iterable.iterator());
    }

    public static String join(Iterable iterable, CharSequence charSequence) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.join(iterable.iterator(), charSequence);
    }

    public static String join(Iterable iterable, CharSequence charSequence, String string, String string2) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.join(iterable.iterator(), charSequence, string, string2);
    }

    public static String join(Iterator iterator, CharSequence charSequence) {
        return IterUtil.join(iterator, charSequence);
    }

    public static List popPart(Stack stack, int n2) {
        if (CollUtil.isEmpty(stack)) {
            return ListUtil.empty();
        }
        ArrayList arrayList = new ArrayList();
        int n3 = stack.size();
        if (n3 > n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(stack.pop());
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                arrayList.add(stack.pop());
            }
        }
        return arrayList;
    }

    public static List popPart(Deque deque, int n2) {
        if (CollUtil.isEmpty(deque)) {
            return ListUtil.empty();
        }
        ArrayList arrayList = new ArrayList();
        int n3 = deque.size();
        if (n3 > n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(deque.pop());
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                arrayList.add(deque.pop());
            }
        }
        return arrayList;
    }

    public static HashMap newHashMap() {
        return MapUtil.newHashMap();
    }

    public static HashMap newHashMap(int n2, boolean bl) {
        return MapUtil.newHashMap(n2, bl);
    }

    public static HashMap newHashMap(int n2) {
        return MapUtil.newHashMap(n2);
    }

    public static HashSet newHashSet(Object ... objectArray) {
        return CollUtil.set(false, objectArray);
    }

    public static LinkedHashSet newLinkedHashSet(Object ... objectArray) {
        return (LinkedHashSet)CollUtil.set(true, objectArray);
    }

    public static HashSet set(boolean bl, Object ... objectArray) {
        if (null == objectArray) {
            return bl ? new LinkedHashSet() : new HashSet();
        }
        int n2 = Math.max((int)((float)objectArray.length / 0.75f) + 1, 16);
        HashSet hashSet = bl ? new LinkedHashSet(n2) : new HashSet(n2);
        Collections.addAll(hashSet, objectArray);
        return hashSet;
    }

    public static HashSet newHashSet(Collection collection) {
        return CollUtil.newHashSet(false, collection);
    }

    public static HashSet newHashSet(boolean bl, Collection collection) {
        return bl ? new LinkedHashSet(collection) : new HashSet(collection);
    }

    public static HashSet newHashSet(boolean bl, Iterator iterator) {
        HashSet hashSet;
        if (null == iterator) {
            return CollUtil.set(bl, null);
        }
        HashSet hashSet2 = hashSet = bl ? new LinkedHashSet() : new HashSet();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public static HashSet newHashSet(boolean bl, Enumeration enumeration) {
        HashSet hashSet;
        if (null == enumeration) {
            return CollUtil.set(bl, null);
        }
        HashSet hashSet2 = hashSet = bl ? new LinkedHashSet() : new HashSet();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        return hashSet;
    }

    public static List list(boolean bl) {
        return ListUtil.list(bl);
    }

    public static List list(boolean bl, Object ... objectArray) {
        return ListUtil.list(bl, objectArray);
    }

    public static List list(boolean bl, Collection collection) {
        return ListUtil.list(bl, collection);
    }

    public static List list(boolean bl, Iterable iterable) {
        return ListUtil.list(bl, iterable);
    }

    public static List list(boolean bl, Iterator iterator) {
        return ListUtil.list(bl, iterator);
    }

    public static List list(boolean bl, Enumeration enumeration) {
        return ListUtil.list(bl, enumeration);
    }

    public static ArrayList newArrayList(Object ... objectArray) {
        return ListUtil.toList(objectArray);
    }

    public static ArrayList toList(Object ... objectArray) {
        return ListUtil.toList(objectArray);
    }

    public static ArrayList newArrayList(Collection collection) {
        return ListUtil.toList(collection);
    }

    public static ArrayList newArrayList(Iterable iterable) {
        return ListUtil.toList(iterable);
    }

    public static ArrayList newArrayList(Iterator iterator) {
        return ListUtil.toList(iterator);
    }

    public static ArrayList newArrayList(Enumeration enumeration) {
        return ListUtil.toList(enumeration);
    }

    public static LinkedList newLinkedList(Object ... objectArray) {
        return ListUtil.toLinkedList(objectArray);
    }

    public static CopyOnWriteArrayList newCopyOnWriteArrayList(Collection collection) {
        return ListUtil.toCopyOnWriteArrayList(collection);
    }

    public static BlockingQueue newBlockingQueue(int n2, boolean bl) {
        AbstractQueue abstractQueue = bl ? new LinkedBlockingDeque(n2) : new ArrayBlockingQueue(n2);
        return abstractQueue;
    }

    public static Collection create(Class clazz) {
        Collection collection;
        if (clazz.isAssignableFrom(AbstractCollection.class)) {
            collection = new ArrayList();
        } else if (clazz.isAssignableFrom(HashSet.class)) {
            collection = new HashSet();
        } else if (clazz.isAssignableFrom(LinkedHashSet.class)) {
            collection = new LinkedHashSet();
        } else if (clazz.isAssignableFrom(TreeSet.class)) {
            collection = new TreeSet((object, object2) -> {
                if (object instanceof Comparable) {
                    return ((Comparable)object).compareTo(object2);
                }
                return CompareUtil.compare((Comparable)((Object)object.toString()), (Comparable)((Object)object2.toString()));
            });
        } else if (clazz.isAssignableFrom(EnumSet.class)) {
            collection = EnumSet.noneOf(ClassUtil.getTypeArgument(clazz));
        } else if (clazz.isAssignableFrom(ArrayList.class)) {
            collection = new ArrayList();
        } else if (clazz.isAssignableFrom(LinkedList.class)) {
            collection = new LinkedList();
        } else {
            try {
                collection = (Collection)ReflectUtil.newInstance(clazz, new Object[0]);
            }
            catch (Exception exception) {
                throw new UtilException(exception);
            }
        }
        return collection;
    }

    public static Map createMap(Class clazz) {
        return MapUtil.createMap(clazz);
    }

    public static ArrayList distinct(Collection collection) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        if (collection instanceof Set) {
            return new ArrayList(collection);
        }
        return new ArrayList(new LinkedHashSet(collection));
    }

    public static List sub(List list, int n2, int n3) {
        return ListUtil.sub(list, n2, n3);
    }

    public static List sub(List list, int n2, int n3, int n4) {
        return ListUtil.sub(list, n2, n3, n4);
    }

    public static List sub(Collection collection, int n2, int n3) {
        return CollUtil.sub(collection, n2, n3, 1);
    }

    public static List sub(Collection collection, int n2, int n3, int n4) {
        if (collection == null || collection.isEmpty()) {
            return ListUtil.empty();
        }
        return CollUtil.sub(new ArrayList(collection), n2, n3, n4);
    }

    public static List splitList(List list, int n2) {
        return ListUtil.split(list, n2);
    }

    public static List split(Collection collection, int n2) {
        ArrayList arrayList = new ArrayList();
        if (CollUtil.isEmpty(collection)) {
            return arrayList;
        }
        ArrayList arrayList2 = new ArrayList(n2);
        for (Object e2 : collection) {
            if (arrayList2.size() >= n2) {
                arrayList.add(arrayList2);
                arrayList2 = new ArrayList(n2);
            }
            arrayList2.add(e2);
        }
        arrayList.add(arrayList2);
        return arrayList;
    }

    public static Collection filter(Collection collection, Editor editor) {
        if (null == collection || null == editor) {
            return collection;
        }
        ArrayList<Object> arrayList = (ArrayList<Object>)ObjectUtil.clone(collection);
        try {
            arrayList.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            arrayList = new ArrayList<Object>();
        }
        for (Object e2 : collection) {
            Object object = editor.edit(e2);
            if (null == object) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public static List filter(List list, Editor editor) {
        return ListUtil.filter(list, editor);
    }

    public static Collection filterNew(Collection collection, Filter filter) {
        if (null == collection || null == filter) {
            return collection;
        }
        ArrayList arrayList = (ArrayList)ObjectUtil.clone(collection);
        try {
            arrayList.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            arrayList = new ArrayList();
        }
        for (Object e2 : collection) {
            if (!filter.accept(e2)) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    public static List filterNew(List list, Filter filter) {
        return ListUtil.filter(list, (Object object) -> filter.accept(object) ? object : null);
    }

    public static Collection removeAny(Collection collection, Object ... objectArray) {
        collection.removeAll(CollUtil.newHashSet(objectArray));
        return collection;
    }

    public static Collection filter(Collection collection, Filter filter) {
        return (Collection)IterUtil.filter(collection, filter);
    }

    public static Collection removeNull(Collection collection) {
        return CollUtil.filter(collection, Objects::nonNull);
    }

    public static Collection removeEmpty(Collection collection) {
        return CollUtil.filter(collection, StrUtil::isNotEmpty);
    }

    public static Collection removeBlank(Collection collection) {
        return CollUtil.filter(collection, StrUtil::isNotBlank);
    }

    public static List extract(Iterable iterable, Editor editor) {
        return CollUtil.extract(iterable, editor, false);
    }

    public static List extract(Iterable iterable, Editor editor, boolean bl) {
        return CollUtil.map(iterable, editor::edit, bl);
    }

    public static List map(Iterable iterable, Function function, boolean bl) {
        ArrayList arrayList = new ArrayList();
        if (null == iterable) {
            return arrayList;
        }
        for (Object t2 : iterable) {
            Object r2 = function.apply(t2);
            if (null == r2 && bl) continue;
            arrayList.add(r2);
        }
        return arrayList;
    }

    public static List getFieldValues(Iterable iterable, String string) {
        return CollUtil.getFieldValues(iterable, string, false);
    }

    public static List getFieldValues(Iterable iterable, String string, boolean bl) {
        return CollUtil.map(iterable, object -> {
            if (object instanceof Map) {
                return ((Map)object).get(string);
            }
            return ReflectUtil.getFieldValue(object, string);
        }, bl);
    }

    public static List getFieldValues(Iterable iterable, String string, Class clazz) {
        List list = CollUtil.getFieldValues(iterable, string);
        return Convert.toList(clazz, list);
    }

    public static Map fieldValueMap(Iterable iterable, String string) {
        return IterUtil.fieldValueMap(null == iterable ? null : iterable.iterator(), string);
    }

    public static Map fieldValueAsMap(Iterable iterable, String string, String string2) {
        return IterUtil.fieldValueAsMap(null == iterable ? null : iterable.iterator(), string, string2);
    }

    public static Object findOne(Iterable iterable, Filter filter) {
        if (null != iterable) {
            for (Object t2 : iterable) {
                if (!filter.accept(t2)) continue;
                return t2;
            }
        }
        return null;
    }

    public static Object findOneByField(Iterable iterable, String string, Object object) {
        return CollUtil.findOne(iterable, object2 -> {
            if (object2 instanceof Map) {
                Map map = (Map)object2;
                Object v2 = map.get(string);
                return ObjectUtil.equal(v2, object);
            }
            Object object3 = ReflectUtil.getFieldValue(object2, string);
            return ObjectUtil.equal(object3, object);
        });
    }

    public static Map filter(Map map, Editor editor) {
        return MapUtil.filter(map, editor);
    }

    public static Map filter(Map map, Filter filter) {
        return MapUtil.filter(map, filter);
    }

    public static int count(Iterable iterable, Matcher matcher) {
        int n2 = 0;
        if (null != iterable) {
            for (Object t2 : iterable) {
                if (null != matcher && !matcher.match(t2)) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static int[] indexOfAll(Collection collection, Matcher matcher) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (null != collection) {
            int n2 = 0;
            for (Object e2 : collection) {
                if (null == matcher || matcher.match(e2)) {
                    arrayList.add(n2);
                }
                ++n2;
            }
        }
        return (int[])Convert.convert(int[].class, arrayList);
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static Collection defaultIfEmpty(Collection collection, Collection collection2) {
        return CollUtil.isEmpty(collection) ? collection2 : collection;
    }

    public static boolean isEmpty(Map map) {
        return MapUtil.isEmpty(map);
    }

    public static boolean isEmpty(Iterable iterable) {
        return IterUtil.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterator iterator) {
        return IterUtil.isEmpty(iterator);
    }

    public static boolean isEmpty(Enumeration enumeration) {
        return null == enumeration || false == enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(Collection collection) {
        return false == CollUtil.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map map) {
        return MapUtil.isNotEmpty(map);
    }

    public static boolean isNotEmpty(Iterable iterable) {
        return IterUtil.isNotEmpty(iterable);
    }

    public static boolean isNotEmpty(Iterator iterator) {
        return IterUtil.isNotEmpty(iterator);
    }

    public static boolean isNotEmpty(Enumeration enumeration) {
        return null != enumeration && enumeration.hasMoreElements();
    }

    public static boolean hasNull(Iterable iterable) {
        return IterUtil.hasNull(iterable);
    }

    public static Map zip(String string, String string2, String string3, boolean bl) {
        return ArrayUtil.zip(StrUtil.split((CharSequence)string, string3), StrUtil.split((CharSequence)string2, string3), bl);
    }

    public static Map zip(String string, String string2, String string3) {
        return CollUtil.zip(string, string2, string3, false);
    }

    public static Map zip(Collection collection, Collection collection2) {
        int n2;
        if (CollUtil.isEmpty(collection) || CollUtil.isEmpty(collection2)) {
            return MapUtil.empty();
        }
        HashMap hashMap = CollUtil.newHashMap(n2);
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        for (n2 = Math.min(collection.size(), collection2.size()); n2 > 0; --n2) {
            hashMap.put(iterator.next(), iterator2.next());
        }
        return hashMap;
    }

    public static HashMap toMap(Iterable iterable) {
        return IterUtil.toMap(iterable);
    }

    public static HashMap toMap(Object[] objectArray) {
        return MapUtil.of(objectArray);
    }

    public static TreeSet toTreeSet(Collection collection, Comparator comparator) {
        TreeSet treeSet = new TreeSet(comparator);
        treeSet.addAll(collection);
        return treeSet;
    }

    public static Enumeration asEnumeration(Iterator iterator) {
        return new IteratorEnumeration(iterator);
    }

    public static Iterator asIterator(Enumeration enumeration) {
        return IterUtil.asIterator(enumeration);
    }

    public static Iterable asIterable(Iterator iterator) {
        return IterUtil.asIterable(iterator);
    }

    public static Collection toCollection(Iterable iterable) {
        return iterable instanceof Collection ? (Collection)iterable : CollUtil.newArrayList(iterable.iterator());
    }

    public static Map toListMap(Iterable iterable) {
        return MapUtil.toListMap(iterable);
    }

    public static List toMapList(Map map) {
        return MapUtil.toMapList(map);
    }

    public static Map toMap(Iterable iterable, Map map, Func1 func1) {
        return IterUtil.toMap(null == iterable ? null : iterable.iterator(), map, func1);
    }

    public static Map toMap(Iterable iterable, Map map, Func1 func1, Func1 func12) {
        return IterUtil.toMap(null == iterable ? null : iterable.iterator(), map, func1, func12);
    }

    public static Collection addAll(Collection collection, Object object) {
        return CollUtil.addAll(collection, object, TypeUtil.getTypeArgument(collection.getClass()));
    }

    public static Collection addAll(Collection collection, Object object, Type object2) {
        Object object3;
        Iterator iterator;
        if (null == collection || null == object) {
            return collection;
        }
        if (TypeUtil.isUnknown((Type)object2)) {
            object2 = Object.class;
        }
        if (object instanceof Iterator) {
            iterator = (EnumerationIter)object;
        } else if (object instanceof Iterable) {
            iterator = ((Iterable)object).iterator();
        } else if (object instanceof Enumeration) {
            iterator = new EnumerationIter((Enumeration)object);
        } else if (ArrayUtil.isArray(object)) {
            iterator = new ArrayIter(object);
        } else if (object instanceof CharSequence) {
            object3 = StrUtil.unWrap((CharSequence)object, '[', ']');
            iterator = StrUtil.splitTrim((CharSequence)object3, ',').iterator();
        } else {
            iterator = CollUtil.newArrayList(object).iterator();
        }
        object3 = ConverterRegistry.getInstance();
        while (iterator.hasNext()) {
            collection.add(((ConverterRegistry)object3).convert((Type)object2, iterator.next()));
        }
        return collection;
    }

    public static Collection addAll(Collection collection, Iterator iterator) {
        if (null != collection && null != iterator) {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        return collection;
    }

    public static Collection addAll(Collection collection, Iterable iterable) {
        return CollUtil.addAll(collection, iterable.iterator());
    }

    public static Collection addAll(Collection collection, Enumeration enumeration) {
        if (null != collection && null != enumeration) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
        return collection;
    }

    public static Collection addAll(Collection collection, Object[] objectArray) {
        if (null != collection && null != objectArray) {
            Collections.addAll(collection, objectArray);
        }
        return collection;
    }

    public static List addAllIfNotContains(List list, List list2) {
        for (Object e2 : list2) {
            if (list.contains(e2)) continue;
            list.add(e2);
        }
        return list;
    }

    public static Object get(Collection collection, int n2) {
        if (null == collection) {
            return null;
        }
        int n3 = collection.size();
        if (0 == n3) {
            return null;
        }
        if (n2 < 0) {
            n2 += n3;
        }
        if (n2 >= n3) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return list.get(n2);
        }
        int n4 = 0;
        for (Object e2 : collection) {
            if (n4 > n2) break;
            if (n4 == n2) {
                return e2;
            }
            ++n4;
        }
        return null;
    }

    public static List getAny(Collection collection, int ... nArray) {
        int n2 = collection.size();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (collection instanceof List) {
            List list = (List)collection;
            for (int n3 : nArray) {
                if (n3 < 0) {
                    n3 += n2;
                }
                arrayList.add(list.get(n3));
            }
        } else {
            Object[] objectArray = collection.toArray();
            for (int n4 : nArray) {
                if (n4 < 0) {
                    n4 += n2;
                }
                arrayList.add(objectArray[n4]);
            }
        }
        return arrayList;
    }

    public static Object getFirst(Iterable iterable) {
        return IterUtil.getFirst(iterable);
    }

    public static Object getFirst(Iterator iterator) {
        return IterUtil.getFirst(iterator);
    }

    public static Object getLast(Collection collection) {
        return CollUtil.get(collection, -1);
    }

    public static Class getElementType(Iterable iterable) {
        return IterUtil.getElementType(iterable);
    }

    public static Class getElementType(Iterator iterator) {
        return IterUtil.getElementType(iterator);
    }

    public static ArrayList valuesOfKeys(Map map, Object ... objectArray) {
        ArrayList arrayList = new ArrayList();
        for (Object object : objectArray) {
            arrayList.add(map.get(object));
        }
        return arrayList;
    }

    public static ArrayList valuesOfKeys(Map map, Iterable iterable) {
        return CollUtil.valuesOfKeys(map, iterable.iterator());
    }

    public static ArrayList valuesOfKeys(Map map, Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(map.get(iterator.next()));
        }
        return arrayList;
    }

    public static List sortPageAll(int n2, int n3, Comparator comparator, Collection ... collectionArray) {
        ArrayList arrayList = new ArrayList(n2 * n3);
        for (Collection collection : collectionArray) {
            arrayList.addAll(collection);
        }
        if (null != comparator) {
            arrayList.sort(comparator);
        }
        return CollUtil.page(n2, n3, arrayList);
    }

    public static List page(int n2, int n3, List list) {
        return ListUtil.page(n2, n3, list);
    }

    public static List sort(Collection collection, Comparator comparator) {
        ArrayList arrayList = new ArrayList(collection);
        arrayList.sort(comparator);
        return arrayList;
    }

    public static List sort(List list, Comparator comparator) {
        return ListUtil.sort(list, comparator);
    }

    public static List sortByProperty(Collection collection, String string) {
        return CollUtil.sort(collection, (Comparator)new PropertyComparator(string));
    }

    public static List sortByProperty(List list, String string) {
        return ListUtil.sortByProperty(list, string);
    }

    public static List sortByPinyin(Collection collection) {
        return CollUtil.sort(collection, (Comparator)new PinyinComparator());
    }

    public static List sortByPinyin(List list) {
        return ListUtil.sortByPinyin(list);
    }

    public static TreeMap sort(Map map, Comparator comparator) {
        TreeMap treeMap = new TreeMap(comparator);
        treeMap.putAll(map);
        return treeMap;
    }

    public static LinkedHashMap sortToMap(Collection collection, Comparator comparator) {
        LinkedList linkedList = new LinkedList(collection);
        linkedList.sort(comparator);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : linkedList) {
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        return linkedHashMap;
    }

    public static LinkedHashMap sortByEntry(Map map, Comparator comparator) {
        return CollUtil.sortToMap(map.entrySet(), comparator);
    }

    public static List sortEntryToList(Collection collection) {
        LinkedList linkedList = new LinkedList(collection);
        linkedList.sort((entry, entry2) -> {
            Object v2 = entry.getValue();
            Object v3 = entry2.getValue();
            if (v2 instanceof Comparable) {
                return ((Comparable)v2).compareTo(v3);
            }
            return v2.toString().compareTo(v3.toString());
        });
        return linkedList;
    }

    public static void forEach(Iterator iterator, CollUtil$Consumer collUtil$Consumer) {
        int n2 = 0;
        while (iterator.hasNext()) {
            collUtil$Consumer.accept(iterator.next(), n2);
            ++n2;
        }
    }

    public static void forEach(Enumeration enumeration, CollUtil$Consumer collUtil$Consumer) {
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            collUtil$Consumer.accept(enumeration.nextElement(), n2);
            ++n2;
        }
    }

    public static void forEach(Map map, CollUtil$KVConsumer collUtil$KVConsumer) {
        int n2 = 0;
        for (Map.Entry entry : map.entrySet()) {
            collUtil$KVConsumer.accept(entry.getKey(), entry.getValue(), n2);
            ++n2;
        }
    }

    public static List group(Collection collection, Hash32 hash32) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        if (CollUtil.isEmpty(collection)) {
            return arrayList;
        }
        if (null == hash32) {
            hash32 = object -> null == object ? 0 : object.hashCode();
        }
        for (Object e2 : collection) {
            int n2 = hash32.hash32(e2);
            if (arrayList.size() - 1 < n2) {
                while (arrayList.size() - 1 < n2) {
                    arrayList.add(null);
                }
                arrayList.set(n2, CollUtil.newArrayList(e2));
                continue;
            }
            List list = (List)arrayList.get(n2);
            if (null == list) {
                arrayList.set(n2, CollUtil.newArrayList(e2));
                continue;
            }
            list.add(e2);
        }
        return arrayList;
    }

    public static List groupByField(Collection collection, String string) {
        return CollUtil.group(collection, new CollUtil$1(string));
    }

    public static List reverse(List list) {
        return ListUtil.reverse(list);
    }

    public static List reverseNew(List list) {
        return ListUtil.reverseNew(list);
    }

    public static List setOrAppend(List list, int n2, Object object) {
        return ListUtil.setOrAppend(list, n2, object);
    }

    public static Set keySet(Collection collection) {
        if (CollUtil.isEmpty(collection)) {
            return new HashSet();
        }
        HashSet hashSet = new HashSet(collection.size() * 16);
        for (Map map : collection) {
            hashSet.addAll(map.keySet());
        }
        return hashSet;
    }

    public static List values(Collection collection) {
        ArrayList arrayList = new ArrayList();
        for (Map map : collection) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public static Comparable max(Collection collection) {
        return (Comparable)Collections.max(collection);
    }

    public static Comparable min(Collection collection) {
        return (Comparable)Collections.min(collection);
    }

    public static Collection unmodifiable(Collection collection) {
        return Collections.unmodifiableCollection(collection);
    }

    public static Collection empty(Class clazz) {
        if (null == clazz) {
            return Collections.emptyList();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            if (NavigableSet.class == clazz) {
                return Collections.emptyNavigableSet();
            }
            if (SortedSet.class == clazz) {
                return Collections.emptySortedSet();
            }
            return Collections.emptySet();
        }
        if (List.class.isAssignableFrom(clazz)) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException(StrUtil.format((CharSequence)"[{}] is not support to get empty!", clazz));
    }

    public static void clear(Collection ... collectionArray) {
        for (Collection collection : collectionArray) {
            if (!CollUtil.isNotEmpty(collection)) continue;
            collection.clear();
        }
    }

    public static void padLeft(List list, int n2, Object object) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            CollUtil.padRight(list, n2, object);
            return;
        }
        for (int i2 = list.size(); i2 < n2; ++i2) {
            list.add(0, object);
        }
    }

    public static void padRight(Collection collection, int n2, Object object) {
        Objects.requireNonNull(collection);
        for (int i2 = collection.size(); i2 < n2; ++i2) {
            collection.add(object);
        }
    }

    public static Collection trans(Collection collection, Function function) {
        return new TransCollection(collection, function);
    }
}

