/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public class BoundedPriorityQueue
extends PriorityQueue {
    private static final long serialVersionUID = 3794348988671694820L;
    private final int capacity;
    private final Comparator comparator;

    public BoundedPriorityQueue(int n2) {
        this(n2, (Comparator)null);
    }

    public BoundedPriorityQueue(int n2, Comparator comparator) {
        super(n2, (object, object2) -> {
            int n2;
            if (comparator != null) {
                n2 = comparator.compare(object, object2);
            } else {
                Comparable comparable = (Comparable)object;
                n2 = comparable.compareTo(object2);
            }
            return -n2;
        });
        this.capacity = n2;
        this.comparator = comparator;
    }

    @Override
    public boolean offer(Object object) {
        if (this.size() >= this.capacity) {
            Object e2 = this.peek();
            if (this.comparator().compare(object, e2) <= 0) {
                return true;
            }
            this.poll();
        }
        return super.offer(object);
    }

    public boolean addAll(Object[] objectArray) {
        return this.addAll(Arrays.asList(objectArray));
    }

    public ArrayList toList() {
        ArrayList arrayList = new ArrayList(this);
        arrayList.sort(this.comparator);
        return arrayList;
    }

    @Override
    public Iterator iterator() {
        return this.toList().iterator();
    }
}

