/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIter
implements Serializable,
Iterable,
Iterator {
    private static final long serialVersionUID = 1L;
    private final Object array;
    private int startIndex;
    private int endIndex;
    private int index;

    public ArrayIter(Object object) {
        this(object, 0);
    }

    public ArrayIter(Object object, int n2) {
        this(object, n2, -1);
    }

    public ArrayIter(Object object, int n2, int n3) {
        this.endIndex = Array.getLength(object);
        if (n3 > 0 && n3 < this.endIndex) {
            this.endIndex = n3;
        }
        if (n2 >= 0 && n2 < this.endIndex) {
            this.startIndex = n2;
        }
        this.array = object;
        this.index = this.startIndex;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return Array.get(this.array, this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported");
    }

    public Object getArray() {
        return this.array;
    }

    public void reset() {
        this.index = this.startIndex;
    }

    public Iterator iterator() {
        return this;
    }
}

