/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.codec;

import com.ccb.core.lang.Assert;
import com.ccb.core.util.StrUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Morse {
    private static final Map ALPHABETS = new HashMap();
    private static final Map DICTIONARIES = new HashMap();
    private final char dit;
    private final char dah;
    private final char split;

    private static void registerMorse(Character c2, String string) {
        ALPHABETS.put(Integer.valueOf(c2.charValue()), string);
        DICTIONARIES.put(string, Integer.valueOf(c2.charValue()));
    }

    public Morse() {
        this('.', '-', '/');
    }

    public Morse(char c2, char c3, char c4) {
        this.dit = c2;
        this.dah = c3;
        this.split = c4;
    }

    public String encode(String string) {
        Assert.notNull(string, "Text should not be null.", new Object[0]);
        string = string.toUpperCase();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.codePointCount(0, string.length());
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = string.codePointAt(i2);
            String string2 = (String)ALPHABETS.get(n3);
            if (string2 == null) {
                string2 = Integer.toBinaryString(n3);
            }
            stringBuilder.append(string2.replace('0', this.dit).replace('1', this.dah)).append(this.split);
        }
        return stringBuilder.toString();
    }

    public String decode(String string) {
        Assert.notNull(string, "Morse should not be null.", new Object[0]);
        char c2 = this.dit;
        char c3 = this.dah;
        char c4 = this.split;
        if (!StrUtil.containsOnly(string, c2, c3, c4)) {
            throw new IllegalArgumentException("Incorrect morse.");
        }
        List list = StrUtil.split((CharSequence)string, c4);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            if (StrUtil.isEmpty(string2)) continue;
            Integer n2 = (Integer)DICTIONARIES.get(string2 = string2.replace(c2, '0').replace(c3, '1'));
            if (n2 == null) {
                n2 = Integer.valueOf(string2, 2);
            }
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    static {
        Morse.registerMorse(Character.valueOf('A'), "01");
        Morse.registerMorse(Character.valueOf('B'), "1000");
        Morse.registerMorse(Character.valueOf('C'), "1010");
        Morse.registerMorse(Character.valueOf('D'), "100");
        Morse.registerMorse(Character.valueOf('E'), "0");
        Morse.registerMorse(Character.valueOf('F'), "0010");
        Morse.registerMorse(Character.valueOf('G'), "110");
        Morse.registerMorse(Character.valueOf('H'), "0000");
        Morse.registerMorse(Character.valueOf('I'), "00");
        Morse.registerMorse(Character.valueOf('J'), "0111");
        Morse.registerMorse(Character.valueOf('K'), "101");
        Morse.registerMorse(Character.valueOf('L'), "0100");
        Morse.registerMorse(Character.valueOf('M'), "11");
        Morse.registerMorse(Character.valueOf('N'), "10");
        Morse.registerMorse(Character.valueOf('O'), "111");
        Morse.registerMorse(Character.valueOf('P'), "0110");
        Morse.registerMorse(Character.valueOf('Q'), "1101");
        Morse.registerMorse(Character.valueOf('R'), "010");
        Morse.registerMorse(Character.valueOf('S'), "000");
        Morse.registerMorse(Character.valueOf('T'), "1");
        Morse.registerMorse(Character.valueOf('U'), "001");
        Morse.registerMorse(Character.valueOf('V'), "0001");
        Morse.registerMorse(Character.valueOf('W'), "011");
        Morse.registerMorse(Character.valueOf('X'), "1001");
        Morse.registerMorse(Character.valueOf('Y'), "1011");
        Morse.registerMorse(Character.valueOf('Z'), "1100");
        Morse.registerMorse(Character.valueOf('0'), "11111");
        Morse.registerMorse(Character.valueOf('1'), "01111");
        Morse.registerMorse(Character.valueOf('2'), "00111");
        Morse.registerMorse(Character.valueOf('3'), "00011");
        Morse.registerMorse(Character.valueOf('4'), "00001");
        Morse.registerMorse(Character.valueOf('5'), "00000");
        Morse.registerMorse(Character.valueOf('6'), "10000");
        Morse.registerMorse(Character.valueOf('7'), "11000");
        Morse.registerMorse(Character.valueOf('8'), "11100");
        Morse.registerMorse(Character.valueOf('9'), "11110");
        Morse.registerMorse(Character.valueOf('.'), "010101");
        Morse.registerMorse(Character.valueOf(','), "110011");
        Morse.registerMorse(Character.valueOf('?'), "001100");
        Morse.registerMorse(Character.valueOf('\''), "011110");
        Morse.registerMorse(Character.valueOf('!'), "101011");
        Morse.registerMorse(Character.valueOf('/'), "10010");
        Morse.registerMorse(Character.valueOf('('), "10110");
        Morse.registerMorse(Character.valueOf(')'), "101101");
        Morse.registerMorse(Character.valueOf('&'), "01000");
        Morse.registerMorse(Character.valueOf(':'), "111000");
        Morse.registerMorse(Character.valueOf(';'), "101010");
        Morse.registerMorse(Character.valueOf('='), "10001");
        Morse.registerMorse(Character.valueOf('+'), "01010");
        Morse.registerMorse(Character.valueOf('-'), "100001");
        Morse.registerMorse(Character.valueOf('_'), "001101");
        Morse.registerMorse(Character.valueOf('\"'), "010010");
        Morse.registerMorse(Character.valueOf('$'), "0001001");
        Morse.registerMorse(Character.valueOf('@'), "011010");
    }
}

