/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.codec;

import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.StrUtil;
import java.nio.charset.Charset;

public class Base32 {
    private static final String BASE32_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final int[] BASE32_LOOKUP = new int[]{255, 255, 26, 27, 28, 29, 30, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255};

    private Base32() {
    }

    public static String encode(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder((byArray.length + 7) * 8 / 5);
        while (n2 < byArray.length) {
            int n4;
            int n5;
            int n6 = n5 = byArray[n2] >= 0 ? byArray[n2] : byArray[n2] + 256;
            if (n3 > 3) {
                int n7 = n2 + 1 < byArray.length ? (byArray[n2 + 1] >= 0 ? byArray[n2 + 1] : byArray[n2 + 1] + 256) : 0;
                n4 = n5 & 255 >> n3;
                n3 = (n3 + 5) % 8;
                n4 <<= n3;
                n4 |= n7 >> 8 - n3;
                ++n2;
            } else {
                n4 = n5 >> 8 - (n3 + 5) & 0x1F;
                if ((n3 = (n3 + 5) % 8) == 0) {
                    ++n2;
                }
            }
            stringBuilder.append(BASE32_CHARS.charAt(n4));
        }
        return stringBuilder.toString();
    }

    public static String encode(String string) {
        return Base32.encode(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encode(String string, String string2) {
        return Base32.encode(StrUtil.bytes((CharSequence)string, string2));
    }

    public static String encode(String string, Charset charset) {
        return Base32.encode(StrUtil.bytes((CharSequence)string, charset));
    }

    public static byte[] decode(String string) {
        byte[] byArray = new byte[string.length() * 5 / 8];
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n4;
            int n5 = string.charAt(i2) - 48;
            if (n5 < 0 || n5 >= BASE32_LOOKUP.length || (n4 = BASE32_LOOKUP[n5]) == 255) continue;
            if (n2 <= 3) {
                if ((n2 = (n2 + 5) % 8) == 0) {
                    int n6 = n3++;
                    byArray[n6] = (byte)(byArray[n6] | n4);
                    if (n3 < byArray.length) continue;
                    break;
                }
                int n7 = n3;
                byArray[n7] = (byte)(byArray[n7] | n4 << 8 - n2);
                continue;
            }
            n2 = (n2 + 5) % 8;
            int n8 = n3++;
            byArray[n8] = (byte)(byArray[n8] | n4 >>> n2);
            if (n3 >= byArray.length) break;
            int n9 = n3;
            byArray[n9] = (byte)(byArray[n9] | n4 << 8 - n2);
        }
        return byArray;
    }

    public static String decodeStr(String string) {
        return Base32.decodeStr(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static String decodeStr(String string, String string2) {
        return StrUtil.str(Base32.decode(string), string2);
    }

    public static String decodeStr(String string, Charset charset) {
        return StrUtil.str(Base32.decode(string), charset);
    }
}

