/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.bean;

import com.ccb.core.annotation.AnnotationUtil;
import com.ccb.core.annotation.PropIgnore;
import com.ccb.core.bean.BeanException;
import com.ccb.core.convert.Convert;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.ModifierUtil;
import com.ccb.core.util.ModifierUtil$ModifierType;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.TypeUtil;
import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class PropDesc {
    final Field field;
    protected Method getter;
    protected Method setter;

    public PropDesc(Field field, Method method, Method method2) {
        this.field = field;
        this.getter = ClassUtil.setAccessible(method);
        this.setter = ClassUtil.setAccessible(method2);
    }

    public String getFieldName() {
        return ReflectUtil.getFieldName(this.field);
    }

    public String getRawFieldName() {
        return null == this.field ? null : this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public Type getFieldType() {
        if (null != this.field) {
            return TypeUtil.getType(this.field);
        }
        return this.findPropType(this.getter, this.setter);
    }

    public Class getFieldClass() {
        if (null != this.field) {
            return TypeUtil.getClass(this.field);
        }
        return this.findPropClass(this.getter, this.setter);
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public boolean isReadable(boolean bl) {
        if (null == this.getter && !ModifierUtil.isPublic(this.field)) {
            return false;
        }
        if (bl && this.isTransientForGet()) {
            return false;
        }
        return false == this.isIgnoreGet();
    }

    public Object getValue(Object object) {
        if (null != this.getter) {
            return ReflectUtil.invoke(object, this.getter, new Object[0]);
        }
        if (ModifierUtil.isPublic(this.field)) {
            return ReflectUtil.getFieldValue(object, this.field);
        }
        return null;
    }

    public Object getValue(Object object, Type type, boolean bl) {
        Object object2;
        Object object3;
        block3: {
            object3 = null;
            try {
                object3 = this.getValue(object);
            }
            catch (Exception exception) {
                if (bl) break block3;
                throw new BeanException(exception, "Get value of [{}] error!", this.getFieldName());
            }
        }
        if (null != object3 && null != type && null != (object2 = Convert.convertWithCheck(type, object3, null, bl))) {
            object3 = object2;
        }
        return object3;
    }

    public boolean isWritable(boolean bl) {
        if (null == this.setter && !ModifierUtil.isPublic(this.field)) {
            return false;
        }
        if (bl && this.isTransientForSet()) {
            return false;
        }
        return false == this.isIgnoreSet();
    }

    public PropDesc setValue(Object object, Object object2) {
        if (null != this.setter) {
            ReflectUtil.invoke(object, this.setter, object2);
        } else if (ModifierUtil.isPublic(this.field)) {
            ReflectUtil.setFieldValue(object, this.field, object2);
        }
        return this;
    }

    public PropDesc setValue(Object object, Object object2, boolean bl, boolean bl2) {
        block5: {
            Class clazz;
            if (bl && null == object2) {
                return this;
            }
            if (null != object2 && !(clazz = this.getFieldClass()).isInstance(object2)) {
                object2 = Convert.convertWithCheck(clazz, object2, null, bl2);
            }
            if (null != object2 || !bl) {
                try {
                    this.setValue(object, object2);
                }
                catch (Exception exception) {
                    if (bl2) break block5;
                    throw new BeanException(exception, "Set value of [{}] error!", this.getFieldName());
                }
            }
        }
        return this;
    }

    private Type findPropType(Method method, Method method2) {
        Type type = null;
        if (null != method) {
            type = TypeUtil.getReturnType(method);
        }
        if (null == type && null != method2) {
            type = TypeUtil.getParamType(method2, 0);
        }
        return type;
    }

    private Class findPropClass(Method method, Method method2) {
        Class clazz = null;
        if (null != method) {
            clazz = TypeUtil.getReturnClass(method);
        }
        if (null == clazz && null != method2) {
            clazz = TypeUtil.getFirstParamClass(method2);
        }
        return clazz;
    }

    private boolean isIgnoreSet() {
        return AnnotationUtil.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation(this.setter, PropIgnore.class);
    }

    private boolean isIgnoreGet() {
        return AnnotationUtil.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation(this.getter, PropIgnore.class);
    }

    private boolean isTransientForGet() {
        boolean bl = ModifierUtil.hasModifier(this.field, ModifierUtil$ModifierType.TRANSIENT);
        if (!bl && null != this.getter && !(bl = ModifierUtil.hasModifier(this.getter, ModifierUtil$ModifierType.TRANSIENT))) {
            bl = AnnotationUtil.hasAnnotation(this.getter, Transient.class);
        }
        return bl;
    }

    private boolean isTransientForSet() {
        boolean bl = ModifierUtil.hasModifier(this.field, ModifierUtil$ModifierType.TRANSIENT);
        if (!bl && null != this.setter && !(bl = ModifierUtil.hasModifier(this.setter, ModifierUtil$ModifierType.TRANSIENT))) {
            bl = AnnotationUtil.hasAnnotation(this.setter, Transient.class);
        }
        return bl;
    }
}

