/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.bean;

import com.ccb.core.bean.BeanException;
import com.ccb.core.bean.BeanUtil;
import com.ccb.core.bean.PropDesc;
import com.ccb.core.clone.CloneSupport;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.ReflectUtil;
import java.io.Serializable;
import java.util.Map;

public class DynaBean
extends CloneSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class beanClass;
    private final Object bean;

    public static DynaBean create(Object object) {
        return new DynaBean(object);
    }

    public static DynaBean create(Class clazz, Object ... objectArray) {
        return new DynaBean(clazz, objectArray);
    }

    public DynaBean(Class clazz, Object ... objectArray) {
        this(ReflectUtil.newInstance(clazz, objectArray));
    }

    public DynaBean(Object object) {
        Assert.notNull(object);
        if (object instanceof DynaBean) {
            object = ((DynaBean)object).getBean();
        }
        this.bean = object;
        this.beanClass = ClassUtil.getClass(object);
    }

    public Object get(String string) {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return ((Map)this.bean).get(string);
        }
        PropDesc propDesc = BeanUtil.getBeanDesc(this.beanClass).getProp(string);
        if (null == propDesc) {
            throw new BeanException("No public field or get method for {}", string);
        }
        return propDesc.getValue(this.bean);
    }

    public boolean containsProp(String string) {
        return null != BeanUtil.getBeanDesc(this.beanClass).getProp(string);
    }

    public Object safeGet(String string) {
        try {
            return this.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void set(String string, Object object) {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            ((Map)this.bean).put(string, object);
        } else {
            PropDesc propDesc = BeanUtil.getBeanDesc(this.beanClass).getProp(string);
            if (null == propDesc) {
                throw new BeanException("No public field or set method for {}", string);
            }
            propDesc.setValue(this.bean, object);
        }
    }

    public Object invoke(String string, Object ... objectArray) {
        return ReflectUtil.invoke(this.bean, string, objectArray);
    }

    public Object getBean() {
        return this.bean;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.bean == null ? 0 : this.bean.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DynaBean dynaBean = (DynaBean)object;
        if (this.bean == null) {
            return dynaBean.bean == null;
        }
        return this.bean.equals(dynaBean.bean);
    }

    public String toString() {
        return this.bean.toString();
    }
}

