/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.bean;

import com.ccb.core.bean.PropDesc;
import com.ccb.core.lang.Assert;
import com.ccb.core.map.CaseInsensitiveMap;
import com.ccb.core.util.BooleanUtil;
import com.ccb.core.util.ModifierUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class BeanDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class beanClass;
    private final Map propMap = new LinkedHashMap();

    public BeanDesc(Class clazz) {
        Assert.notNull(clazz);
        this.beanClass = clazz;
        this.init();
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public String getSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public Map getPropMap(boolean bl) {
        return bl ? new CaseInsensitiveMap(1.0f, this.propMap) : this.propMap;
    }

    public Collection getProps() {
        return this.propMap.values();
    }

    public PropDesc getProp(String string) {
        return (PropDesc)this.propMap.get(string);
    }

    public Field getField(String string) {
        PropDesc propDesc = (PropDesc)this.propMap.get(string);
        return null == propDesc ? null : propDesc.getField();
    }

    public Method getGetter(String string) {
        PropDesc propDesc = (PropDesc)this.propMap.get(string);
        return null == propDesc ? null : propDesc.getGetter();
    }

    public Method getSetter(String string) {
        PropDesc propDesc = (PropDesc)this.propMap.get(string);
        return null == propDesc ? null : propDesc.getSetter();
    }

    private BeanDesc init() {
        Method[] methodArray = ReflectUtil.getMethods(this.beanClass);
        for (Field field : ReflectUtil.getFields(this.beanClass)) {
            if (ModifierUtil.isStatic(field)) continue;
            PropDesc propDesc = this.createProp(field, methodArray);
            this.propMap.put(propDesc.getFieldName(), propDesc);
        }
        return this;
    }

    private PropDesc createProp(Field field, Method[] methodArray) {
        PropDesc propDesc = this.findProp(field, methodArray, false);
        if (null == propDesc.getter || null == propDesc.setter) {
            PropDesc propDesc2 = this.findProp(field, methodArray, true);
            if (null == propDesc.getter) {
                propDesc.getter = propDesc2.getter;
            }
            if (null == propDesc.setter) {
                propDesc.setter = propDesc2.setter;
            }
        }
        return propDesc;
    }

    private PropDesc findProp(Field field, Method[] methodArray, boolean bl) {
        String string = field.getName();
        Class<?> clazz = field.getType();
        boolean bl2 = BooleanUtil.isBoolean(clazz);
        Method method = null;
        Method method2 = null;
        for (Method method3 : methodArray) {
            Class<?>[] classArray = method3.getParameterTypes();
            if (classArray.length > 1) continue;
            String string2 = method3.getName();
            if (classArray.length == 0) {
                if (this.isMatchGetter(string2, string, bl2, bl)) {
                    method = method3;
                }
            } else if (this.isMatchSetter(string2, string, bl2, bl)) {
                method2 = method3;
            }
            if (null != method && null != method2) break;
        }
        return new PropDesc(field, method, method2);
    }

    private boolean isMatchGetter(String string, String string2, boolean bl, boolean bl2) {
        if (bl2) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        } else {
            string2 = StrUtil.upperFirst(string2);
        }
        if (!string.startsWith("get") && !string.startsWith("is")) {
            return false;
        }
        if ("getclass".equals(string)) {
            return false;
        }
        if (bl && (string2.startsWith("is") ? string.equals(string2) || string.equals("get" + string2) || string.equals("is" + string2) : string.equals("is" + string2))) {
            return true;
        }
        return string.equals("get" + string2);
    }

    private boolean isMatchSetter(String string, String string2, boolean bl, boolean bl2) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        if (!string.startsWith("set")) {
            return false;
        }
        if (bl && string2.startsWith("is") && (string.equals("set" + StrUtil.removePrefix(string2, "is")) || string.equals("set" + string2))) {
            return true;
        }
        return string.equals("set" + string2);
    }
}

