/*
 * Decompiled with CFR 0.152.
 */
package netpay.merchant.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import netpay.merchant.crypto.DER;
import netpay.merchant.crypto.RSAPrivKey;

public class RSAPrivKeyCrt
extends RSAPrivKey
implements RSAPrivateCrtKey {
    public static final String ident = "$Id: RSAPrivKeyCrt.java,v 1.7 1999/02/02 00:58:02 leachbj Exp $";
    protected BigInteger exponent;
    protected BigInteger p;
    protected BigInteger q;
    protected BigInteger qInv;
    protected BigInteger pMinus1;
    protected BigInteger qMinus1;
    protected BigInteger dP;
    protected BigInteger dQ;

    public RSAPrivKeyCrt() {
    }

    public RSAPrivKeyCrt(BigInteger biginteger, BigInteger biginteger1, BigInteger biginteger2, BigInteger biginteger3, BigInteger biginteger4, BigInteger biginteger5, BigInteger biginteger6, BigInteger biginteger7) {
        super(biginteger, biginteger2);
        this.exponent = biginteger1;
        this.p = biginteger3;
        this.q = biginteger4;
        this.dP = biginteger5;
        this.dQ = biginteger6;
        this.qInv = biginteger7;
    }

    public RSAPrivKeyCrt(byte[] abyte0) {
        this.pkcs8Decode(abyte0);
    }

    public BigInteger getCrtCoefficient() {
        return this.qInv;
    }

    public byte[] getEncoded() {
        return this.pkcs8Encode();
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public BigInteger getPrimeExponentP() {
        return this.dP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.dQ;
    }

    public BigInteger getPrimeP() {
        return this.p;
    }

    public BigInteger getPrimeQ() {
        return this.q;
    }

    public BigInteger getPublicExponent() {
        return this.exponent;
    }

    private void pkcs8Decode(byte[] abyte0) {
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
        try {
            int i = DER.readTag(bytearrayinputstream);
            int j = DER.readLen(bytearrayinputstream);
            bytearrayinputstream.skip(DER.version.length);
            bytearrayinputstream.skip(DER.rsaEncryptionAlgorithmIdentifier.length);
            i = DER.readTag(bytearrayinputstream);
            j = DER.readLen(bytearrayinputstream);
            i = DER.readTag(bytearrayinputstream);
            j = DER.readLen(bytearrayinputstream);
            bytearrayinputstream.skip(DER.version.length);
            this.modulus = DER.readDERint(bytearrayinputstream);
            this.exponent = DER.readDERint(bytearrayinputstream);
            this.d = DER.readDERint(bytearrayinputstream);
            this.p = DER.readDERint(bytearrayinputstream);
            this.q = DER.readDERint(bytearrayinputstream);
            this.dP = DER.readDERint(bytearrayinputstream);
            this.dQ = DER.readDERint(bytearrayinputstream);
            this.qInv = DER.readDERint(bytearrayinputstream);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            throw new ExceptionInInitializerError(ioexception);
        }
    }

    private byte[] pkcs8Encode() {
        try {
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            bytearrayoutputstream.write(DER.version);
            DER.writeDERint(bytearrayoutputstream, this.modulus);
            DER.writeDERint(bytearrayoutputstream, this.exponent);
            DER.writeDERint(bytearrayoutputstream, this.d);
            DER.writeDERint(bytearrayoutputstream, this.p);
            DER.writeDERint(bytearrayoutputstream, this.q);
            DER.writeDERint(bytearrayoutputstream, this.dP);
            DER.writeDERint(bytearrayoutputstream, this.dQ);
            DER.writeDERint(bytearrayoutputstream, this.qInv);
            byte[] abyte0 = bytearrayoutputstream.toByteArray();
            bytearrayoutputstream = new ByteArrayOutputStream();
            bytearrayoutputstream.write(DER.SEQUENCE | DER.CONSTRUCTED);
            DER.writeDERlen(bytearrayoutputstream, abyte0.length);
            bytearrayoutputstream.write(abyte0);
            abyte0 = bytearrayoutputstream.toByteArray();
            bytearrayoutputstream = new ByteArrayOutputStream();
            bytearrayoutputstream.write(DER.version);
            bytearrayoutputstream.write(DER.rsaEncryptionAlgorithmIdentifier);
            bytearrayoutputstream.write(DER.OCTET_STRING);
            DER.writeDERlen(bytearrayoutputstream, abyte0.length);
            bytearrayoutputstream.write(abyte0);
            byte[] abyte1 = bytearrayoutputstream.toByteArray();
            bytearrayoutputstream = new ByteArrayOutputStream();
            bytearrayoutputstream.write(DER.SEQUENCE | DER.CONSTRUCTED);
            DER.writeDERlen(bytearrayoutputstream, abyte1.length);
            bytearrayoutputstream.write(abyte1);
            return bytearrayoutputstream.toByteArray();
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            throw new ExceptionInInitializerError(ioexception);
        }
    }

    public String toString() {
        return this.modulus.toString(16) + "." + this.exponent.toString(16) + "." + this.d.toString(16) + "." + this.p.toString(16) + "." + this.q.toString(16) + "." + this.dP.toString(16) + "." + this.dQ.toString(16) + "." + this.qInv.toString(16);
    }
}

