/*
 * Decompiled with CFR 0.152.
 */
package netpay.merchant.crypto;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.StringTokenizer;
import netpay.merchant.crypto.AsciiEncodedKeySpec;
import netpay.merchant.crypto.RSAPrivKey;
import netpay.merchant.crypto.RSAPrivKeyCrt;
import netpay.merchant.crypto.RSAPubKey;

public class RSAKeyFactory
extends KeyFactorySpi {
    public static final String ident = "$Id: RSAKeyFactory.java,v 1.13 1999/02/17 01:40:52 leachbj Exp $";
    static Class class$java$security$spec$X509EncodedKeySpec;
    static Class class$java$security$spec$RSAPublicKeySpec;
    static Class class$java$security$spec$PKCS8EncodedKeySpec;
    static Class class$java$security$spec$RSAPrivateCrtKeySpec;
    static Class class$java$security$spec$RSAPrivateKeySpec;

    static Class getClass(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keyspec) throws InvalidKeySpecException {
        if (keyspec instanceof AsciiEncodedKeySpec) {
            BigInteger[] abiginteger = RSAKeyFactory.parseKey(((AsciiEncodedKeySpec)keyspec).getEncoded());
            if (abiginteger.length == 8) {
                return new RSAPrivKeyCrt(abiginteger[0], abiginteger[1], abiginteger[2], abiginteger[3], abiginteger[4], abiginteger[5], abiginteger[6], abiginteger[7]);
            }
            return new RSAPrivKey(abiginteger[0], abiginteger[1]);
        }
        if (keyspec instanceof PKCS8EncodedKeySpec) {
            return new RSAPrivKeyCrt(((PKCS8EncodedKeySpec)keyspec).getEncoded());
        }
        if (keyspec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rsaprivatecrtkeyspec = (RSAPrivateCrtKeySpec)keyspec;
            return new RSAPrivKeyCrt(rsaprivatecrtkeyspec.getModulus(), rsaprivatecrtkeyspec.getPublicExponent(), rsaprivatecrtkeyspec.getPrivateExponent(), rsaprivatecrtkeyspec.getPrimeP(), rsaprivatecrtkeyspec.getPrimeQ(), rsaprivatecrtkeyspec.getPrimeExponentP(), rsaprivatecrtkeyspec.getPrimeExponentQ(), rsaprivatecrtkeyspec.getCrtCoefficient());
        }
        if (keyspec instanceof RSAPrivateKeySpec) {
            RSAPrivateKeySpec rsaprivatekeyspec = (RSAPrivateKeySpec)keyspec;
            return new RSAPrivKey(rsaprivatekeyspec.getModulus(), rsaprivatekeyspec.getPrivateExponent());
        }
        throw new InvalidKeySpecException("Unknown KeySpec type.");
    }

    protected PublicKey engineGeneratePublic(KeySpec keyspec) throws InvalidKeySpecException {
        if (keyspec instanceof AsciiEncodedKeySpec) {
            BigInteger[] abiginteger = RSAKeyFactory.parseKey(((AsciiEncodedKeySpec)keyspec).getEncoded());
            if (abiginteger.length >= 2) {
                return new RSAPubKey(abiginteger[0], abiginteger[1]);
            }
            throw new InvalidKeySpecException("Incomplete EncodedKeySpec.");
        }
        if (keyspec instanceof X509EncodedKeySpec) {
            return new RSAPubKey(((X509EncodedKeySpec)keyspec).getEncoded());
        }
        if (keyspec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rsapublickeyspec = (RSAPublicKeySpec)keyspec;
            return new RSAPubKey(rsapublickeyspec.getModulus(), rsapublickeyspec.getPublicExponent());
        }
        throw new InvalidKeySpecException("Unknown KeySpec type.");
    }

    protected KeySpec engineGetKeySpec(Key key, Class class1) throws InvalidKeySpecException {
        if (key instanceof RSAPublicKey) {
            if ((class$java$security$spec$X509EncodedKeySpec == null ? (class$java$security$spec$X509EncodedKeySpec = RSAKeyFactory.getClass("java.security.spec.X509EncodedKeySpec")) : class$java$security$spec$X509EncodedKeySpec).isAssignableFrom(class1)) {
                return new X509EncodedKeySpec(((X509EncodedKeySpec)((Object)key)).getEncoded());
            }
            if ((class$java$security$spec$RSAPublicKeySpec == null ? (class$java$security$spec$RSAPublicKeySpec = RSAKeyFactory.getClass("java.security.spec.RSAPublicKeySpec")) : class$java$security$spec$RSAPublicKeySpec).isAssignableFrom(class1)) {
                RSAPublicKey rsapublickey = (RSAPublicKey)key;
                return new RSAPublicKeySpec(rsapublickey.getModulus(), rsapublickey.getPublicExponent());
            }
        } else if (key instanceof RSAPrivateKey) {
            if ((class$java$security$spec$PKCS8EncodedKeySpec == null ? (class$java$security$spec$PKCS8EncodedKeySpec = RSAKeyFactory.getClass("java.security.spec.PKCS8EncodedKeySpec")) : class$java$security$spec$PKCS8EncodedKeySpec).isAssignableFrom(class1)) {
                return new PKCS8EncodedKeySpec(((PKCS8EncodedKeySpec)((Object)key)).getEncoded());
            }
            if ((class$java$security$spec$RSAPrivateCrtKeySpec == null ? (class$java$security$spec$RSAPrivateCrtKeySpec = RSAKeyFactory.getClass("java.security.spec.RSAPrivateCrtKeySpec")) : class$java$security$spec$RSAPrivateCrtKeySpec).isAssignableFrom(class1)) {
                RSAPrivKeyCrt rsaprivkeycrt = (RSAPrivKeyCrt)key;
                return new RSAPrivateCrtKeySpec(rsaprivkeycrt.getModulus(), rsaprivkeycrt.getPublicExponent(), rsaprivkeycrt.getPrivateExponent(), rsaprivkeycrt.getPrimeP(), rsaprivkeycrt.getPrimeQ(), rsaprivkeycrt.getPrimeExponentP(), rsaprivkeycrt.getPrimeExponentQ(), rsaprivkeycrt.getCrtCoefficient());
            }
            if ((class$java$security$spec$RSAPrivateKeySpec == null ? (class$java$security$spec$RSAPrivateKeySpec = RSAKeyFactory.getClass("java.security.spec.RSAPrivateKeySpec")) : class$java$security$spec$RSAPrivateKeySpec).isAssignableFrom(class1)) {
                RSAPrivateKey rsaprivatekey = (RSAPrivateKey)key;
                return new RSAPrivateKeySpec(rsaprivatekey.getModulus(), rsaprivatekey.getPrivateExponent());
            }
        }
        throw new InvalidKeySpecException("Invalid KeySpec.");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPrivateCrtKey) {
            if (key instanceof RSAPrivKeyCrt) {
                return key;
            }
            RSAPrivateCrtKey rsaprivatecrtkey = (RSAPrivateCrtKey)key;
            return new RSAPrivKeyCrt(rsaprivatecrtkey.getModulus(), rsaprivatecrtkey.getPublicExponent(), rsaprivatecrtkey.getPrivateExponent(), rsaprivatecrtkey.getPrimeP(), rsaprivatecrtkey.getPrimeQ(), rsaprivatecrtkey.getPrimeExponentP(), rsaprivatecrtkey.getPrimeExponentQ(), rsaprivatecrtkey.getCrtCoefficient());
        }
        if (key instanceof RSAPrivateKey) {
            if (key instanceof RSAPrivateKey) {
                return key;
            }
            RSAPrivateKey rsaprivatekey = (RSAPrivateKey)key;
            return new RSAPrivKey(rsaprivatekey.getModulus(), rsaprivatekey.getPrivateExponent());
        }
        if (key instanceof RSAPublicKey) {
            if (key instanceof RSAPublicKey) {
                return key;
            }
            RSAPublicKey rsapublickey = (RSAPublicKey)key;
            return new RSAPubKey(rsapublickey.getModulus(), rsapublickey.getPublicExponent());
        }
        throw new InvalidKeyException("Unsupported key type.");
    }

    protected static BigInteger[] parseKey(byte[] abyte0) {
        String s = new String(abyte0);
        StringTokenizer stringtokenizer = new StringTokenizer(s, ".");
        int i = stringtokenizer.countTokens();
        BigInteger[] abiginteger = i > 2 ? new BigInteger[8] : new BigInteger[2];
        for (int j = 0; j != i; ++j) {
            abiginteger[j] = new BigInteger(stringtokenizer.nextToken(), 16);
        }
        if (i > 2) {
            BigInteger biginteger = abiginteger[2];
            BigInteger biginteger1 = abiginteger[3];
            BigInteger biginteger2 = abiginteger[4];
            if (biginteger1.compareTo(biginteger2) < 0) {
                BigInteger biginteger5 = biginteger1;
                abiginteger[3] = biginteger1 = biginteger2;
                abiginteger[4] = biginteger2 = biginteger5;
            }
            BigInteger biginteger3 = biginteger1.subtract(BigInteger.valueOf(1L));
            BigInteger biginteger4 = biginteger2.subtract(BigInteger.valueOf(1L));
            abiginteger[5] = biginteger.remainder(biginteger3);
            abiginteger[6] = biginteger.remainder(biginteger4);
            abiginteger[7] = biginteger2.modInverse(biginteger1);
        }
        return abiginteger;
    }
}

