/*
 * Decompiled with CFR 0.152.
 */
package netpay.merchant.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import netpay.merchant.crypto.InlineIvParameterSpec;

public abstract class BlockCipher
extends CipherSpi {
    public static final String ident = "$Id: BlockCipher.java,v 1.25 1999/02/11 04:28:32 leachbj Exp $";
    protected static final int BLOCK_SIZE = 8;
    protected static final int ECB = 0;
    protected static final int CBC = 1;
    protected byte[] buffer;
    protected int bufferPos;
    protected int mode;
    protected boolean paddedStream = false;
    protected int streamMode = 0;
    protected byte[] ivec;
    protected byte[] cbcV;
    protected boolean ivInline;
    protected boolean ivEncrypted;
    protected boolean firstBlock;
    protected Key key;
    protected SecureRandom random;
    static Class class$javax$crypto$spec$IvParameterSpec;
    static Class class$au$net$aba$crypto$spec$InlineIvParameterSpec;

    static Class getClass(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }

    protected abstract int decryptBlock(byte[] var1, int var2, int var3, byte[] var4, int var5) throws BadPaddingException;

    protected abstract int encryptBlock(byte[] var1, int var2, int var3, byte[] var4, int var5) throws IllegalBlockSizeException;

    protected byte[] engineDoFinal(byte[] abyte0, int i, int j) throws IllegalBlockSizeException, BadPaddingException {
        byte[] abyte1 = new byte[this.engineGetOutputSize(j)];
        try {
            int k = this.engineDoFinal(abyte0, i, j, abyte1, 0);
            if (k != abyte1.length) {
                byte[] abyte2 = new byte[k];
                System.arraycopy(abyte1, 0, abyte2, 0, k);
                abyte1 = abyte2;
            }
        }
        catch (ShortBufferException shortbufferexception) {
            throw new BadPaddingException("ShortBufferException: " + shortbufferexception.getMessage());
        }
        return abyte1;
    }

    protected int engineDoFinal(byte[] abyte0, int i, int j, byte[] abyte1, int k) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int l = this.engineGetBlockSize();
        int i1 = this.processAllBlocks(abyte0, i, j, abyte1, k);
        k += i1;
        if (this.mode == 1) {
            if (this.bufferPos == l) {
                int j1 = this.processBlock(this.buffer, 0, l, abyte1, k);
                k += j1;
                i1 += j1;
                this.bufferPos = 0;
            }
            if (this.paddedStream) {
                int k1 = l - this.bufferPos;
                while (this.bufferPos < l) {
                    this.buffer[this.bufferPos] = (byte)k1;
                    ++this.bufferPos;
                }
            }
            if (this.bufferPos > 0) {
                i1 += this.processBlock(this.buffer, 0, this.bufferPos, abyte1, k);
                this.bufferPos = 0;
            }
        } else if (this.mode == 2) {
            if (this.bufferPos > 0) {
                if (this.bufferPos == l) {
                    i1 += this.processBlock(this.buffer, 0, l, abyte1, k);
                    this.bufferPos = 0;
                } else {
                    throw new IllegalBlockSizeException("input truncated.");
                }
            }
            if (this.paddedStream) {
                int l1 = abyte1[k + l - 1] & 0xFF;
                i1 -= l1;
            }
        }
        this.reset();
        return i1;
    }

    protected int engineGetBlockSize() {
        return 8;
    }

    protected byte[] engineGetIV() {
        if (this.ivec != null) {
            int i = this.engineGetBlockSize();
            byte[] abyte0 = new byte[i];
            System.arraycopy(this.ivec, 0, abyte0, 0, i);
            return abyte0;
        }
        return null;
    }

    protected int engineGetOutputSize(int i) {
        int j = this.engineGetBlockSize();
        if (this.firstBlock && this.ivInline) {
            if (this.mode == 1) {
                i += j;
            } else if (this.mode == 2) {
                i -= j;
            }
        }
        i += this.bufferPos;
        if (this.paddedStream) {
            if (i % j == 0) {
                i += j;
            }
            return (i + j - 1) / j * j;
        }
        return i / j * j;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int i, Key key1, AlgorithmParameters algorithmparameters, SecureRandom securerandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmparameterspec = null;
        if (algorithmparameters != null) {
            try {
                algorithmparameterspec = (AlgorithmParameterSpec)algorithmparameters.getParameterSpec(class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = BlockCipher.getClass("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec);
            }
            catch (Exception _ex) {
                try {
                    algorithmparameterspec = (AlgorithmParameterSpec)algorithmparameters.getParameterSpec(class$au$net$aba$crypto$spec$InlineIvParameterSpec == null ? (class$au$net$aba$crypto$spec$InlineIvParameterSpec = BlockCipher.getClass("netpay.merchant.crypto.InlineIvParameterSpec")) : class$au$net$aba$crypto$spec$InlineIvParameterSpec);
                }
                catch (Exception exception) {
                    throw new InvalidAlgorithmParameterException("Processing error: " + exception);
                }
            }
        }
        this.engineInit(i, key1, algorithmparameterspec, securerandom);
    }

    protected void engineInit(int i, Key key1, SecureRandom securerandom) throws InvalidKeyException {
        try {
            this.engineInit(i, key1, (AlgorithmParameterSpec)null, securerandom);
        }
        catch (InvalidAlgorithmParameterException invalidalgorithmparameterexception) {
            throw new InvalidKeyException("InvalidAlgorithmParameterException: " + invalidalgorithmparameterexception.getMessage());
        }
    }

    protected void engineInit(int i, Key key1, AlgorithmParameterSpec algorithmparameterspec, SecureRandom securerandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.reset();
        this.mode = i;
        this.random = securerandom;
        this.key = key1;
        if (this.streamMode == 1) {
            int j = this.engineGetBlockSize();
            this.ivec = new byte[j];
            this.cbcV = new byte[j];
            if (algorithmparameterspec instanceof IvParameterSpec) {
                System.arraycopy(((IvParameterSpec)algorithmparameterspec).getIV(), 0, this.ivec, 0, j);
            } else {
                if (algorithmparameterspec instanceof InlineIvParameterSpec) {
                    this.ivInline = true;
                    this.firstBlock = true;
                    this.ivEncrypted = ((InlineIvParameterSpec)algorithmparameterspec).isEncryptedIv();
                }
                securerandom.nextBytes(this.ivec);
            }
            System.arraycopy(this.ivec, 0, this.cbcV, 0, j);
        }
        this.setKey(key1);
    }

    protected void engineSetMode(String s) throws NoSuchAlgorithmException {
        if (s.equals("ECB")) {
            this.streamMode = 0;
        } else if (s.equals("CBC")) {
            this.streamMode = 1;
        } else {
            throw new NoSuchAlgorithmException("Mode " + s + " not supported.");
        }
    }

    protected void engineSetPadding(String s) throws NoSuchPaddingException {
        if (s.equals("PKCS5Padding")) {
            this.paddedStream = true;
        } else if (s.equals("NoPadding")) {
            this.paddedStream = false;
        } else {
            throw new NoSuchPaddingException("Unsupported padding " + s);
        }
    }

    protected byte[] engineUpdate(byte[] abyte0, int i, int j) {
        byte[] abyte1 = null;
        int k = this.engineGetOutputSize(j);
        if (k != 0) {
            abyte1 = new byte[k];
        }
        try {
            k = this.engineUpdate(abyte0, i, j, abyte1, 0);
        }
        catch (ShortBufferException shortbufferexception) {
            shortbufferexception.printStackTrace();
            throw new RuntimeException("ShortBufferException: " + shortbufferexception.getMessage());
        }
        if (abyte1 != null && k != abyte1.length) {
            byte[] abyte2 = new byte[k];
            System.arraycopy(abyte1, 0, abyte2, 0, k);
            abyte1 = abyte2;
        }
        return abyte1;
    }

    protected int engineUpdate(byte[] abyte0, int i, int j, byte[] abyte1, int k) throws ShortBufferException {
        try {
            return this.processAllBlocks(abyte0, i, j, abyte1, k);
        }
        catch (BadPaddingException badpaddingexception) {
            badpaddingexception.printStackTrace();
        }
        catch (IllegalBlockSizeException illegalblocksizeexception) {
            illegalblocksizeexception.printStackTrace();
        }
        throw new ShortBufferException("Internal error, see stacktrace on console.");
    }

    private int processAllBlocks(byte[] abyte0, int i, int j, byte[] abyte1, int k) throws BadPaddingException, IllegalBlockSizeException {
        int l = this.engineGetBlockSize();
        int i1 = 0;
        if (j < l - this.bufferPos) {
            if (j > 0) {
                System.arraycopy(abyte0, i, this.buffer, this.bufferPos, j);
                this.bufferPos += j;
            }
            return 0;
        }
        if (j == l - this.bufferPos) {
            if (j > 0) {
                System.arraycopy(abyte0, i, this.buffer, this.bufferPos, j);
            }
            if (this.paddedStream) {
                this.bufferPos += j;
                return 0;
            }
            i1 = this.processBlock(this.buffer, 0, l, abyte1, k);
            this.bufferPos = 0;
            return i1;
        }
        int j1 = l - this.bufferPos;
        System.arraycopy(abyte0, i, this.buffer, this.bufferPos, j1);
        i1 = this.processBlock(this.buffer, 0, l, abyte1, k);
        j -= j1;
        i += j1;
        k += i1;
        this.bufferPos = 0;
        j1 = (j + l - 1) / l;
        int k1 = j % l;
        for (int l1 = 0; l1 < j1 - 1; ++l1) {
            int i2 = this.processBlock(abyte0, i, l, abyte1, k);
            i += l;
            k += i2;
            i1 += i2;
        }
        if (k1 == 0) {
            if (this.paddedStream) {
                System.arraycopy(abyte0, i, this.buffer, 0, l);
                this.bufferPos = l;
            } else {
                int j2 = this.processBlock(abyte0, i, l, abyte1, k);
                k += j2;
                i1 += j2;
                this.bufferPos = 0;
            }
        } else {
            System.arraycopy(abyte0, i, this.buffer, 0, k1);
            this.bufferPos = k1;
        }
        return i1;
    }

    private int processBlock(byte[] abyte0, int i, int j, byte[] abyte1, int k) throws BadPaddingException, IllegalBlockSizeException {
        int l = this.engineGetBlockSize();
        int i1 = 0;
        if (this.firstBlock && this.ivInline) {
            this.firstBlock = false;
            if (this.mode == 1) {
                int j1;
                if (this.ivEncrypted) {
                    j1 = this.encryptBlock(this.ivec, 0, l, abyte1, k);
                } else {
                    System.arraycopy(this.ivec, 0, abyte1, k, l);
                    j1 = l;
                }
                k += j1;
                i1 += j1;
            } else {
                if (this.ivEncrypted) {
                    this.decryptBlock(abyte0, i, j, this.ivec, 0);
                } else {
                    System.arraycopy(abyte0, i, this.ivec, 0, l);
                }
                System.arraycopy(this.ivec, 0, this.cbcV, 0, l);
                return 0;
            }
        }
        if (this.mode == 1) {
            if (this.streamMode == 1) {
                for (int k1 = 0; k1 < l; ++k1) {
                    int n = k1;
                    this.cbcV[n] = (byte)(this.cbcV[n] ^ abyte0[i + k1]);
                }
                abyte0 = this.cbcV;
                i = 0;
            }
            i1 += this.encryptBlock(abyte0, i, j, abyte1, k);
            if (this.streamMode == 1) {
                System.arraycopy(abyte1, k, this.cbcV, 0, l);
            }
        } else {
            i1 += this.decryptBlock(abyte0, i, j, abyte1, k);
            if (this.streamMode == 1) {
                for (int l1 = 0; l1 < l; ++l1) {
                    int n = k + l1;
                    abyte1[n] = (byte)(abyte1[n] ^ this.cbcV[l1]);
                }
                System.arraycopy(abyte0, i, this.cbcV, 0, l);
            }
        }
        return i1;
    }

    protected void reset() {
        if (this.buffer != null) {
            for (int i = 0; i < this.buffer.length; ++i) {
                this.buffer[0] = 0;
            }
            this.buffer = null;
        }
        if (this.ivec != null) {
            System.arraycopy(this.ivec, 0, this.cbcV, 0, this.engineGetBlockSize());
        }
        if (this.key != null) {
            try {
                this.setKey(this.key);
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
        this.buffer = new byte[this.engineGetBlockSize()];
        this.bufferPos = 0;
        this.firstBlock = this.ivInline;
    }

    protected abstract void setKey(Key var1) throws InvalidKeyException;
}

