package com.ruoyi.system.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.system.mapper.YqszhZbMapper;
import com.ruoyi.system.domain.YqszhZb;
import com.ruoyi.system.service.IYqszhZbService;

/**
 * 油气数智化-分类Service业务层处理
 *
 * @author ruoyi
 * @date 2024-10-23
 */
@Service
public class YqszhZbServiceImpl implements IYqszhZbService
{
    @Autowired
    private YqszhZbMapper yqszhZbMapper;

    /**
     * 查询油气数智化-分类
     *
     * @param id 油气数智化-分类主键
     * @return 油气数智化-分类
     */
    @Override
    public YqszhZb selectYqszhZbById(Long id)
    {
        return yqszhZbMapper.selectYqszhZbById(id);
    }

    /**
     * 查询油气数智化-分类列表
     *
     * @param yqszhZb 油气数智化-分类
     * @return 油气数智化-分类
     */
    @Override
    public List<YqszhZb> selectYqszhZbList(YqszhZb yqszhZb)
    {
        return yqszhZbMapper.selectYqszhZbList(yqszhZb);
    }

    @Override
    public List<YqszhZb> selectZb(YqszhZb yqszhZb)
    {
        return yqszhZbMapper.selectZb(yqszhZb);
    }

    /**
     * 新增油气数智化-分类
     *
     * @param yqszhZb 油气数智化-分类
     * @return 结果
     */
    @Override
    public int insertYqszhZb(YqszhZb yqszhZb)
    {
        yqszhZb.setCreateTime(DateUtils.getNowDate());
        return yqszhZbMapper.insertYqszhZb(yqszhZb);
    }

    /**
     * 修改油气数智化-分类
     *
     * @param yqszhZb 油气数智化-分类
     * @return 结果
     */
    @Override
    public int updateYqszhZb(YqszhZb yqszhZb)
    {
        yqszhZb.setUpdateTime(DateUtils.getNowDate());
        return yqszhZbMapper.updateYqszhZb(yqszhZb);
    }

    /**
     * 批量删除油气数智化-分类
     *
     * @param ids 需要删除的油气数智化-分类主键
     * @return 结果
     */
    @Override
    public int deleteYqszhZbByIds(Long[] ids)
    {
        return yqszhZbMapper.deleteYqszhZbByIds(ids);
    }

    /**
     * 删除油气数智化-分类信息
     *
     * @param id 油气数智化-分类主键
     * @return 结果
     */
    @Override
    public int deleteYqszhZbById(Long id)
    {
        return yqszhZbMapper.deleteYqszhZbById(id);
    }
}
