package com.ruoyi.system.service.impl;


import java.util.List;

import cn.hutool.core.codec.Base64;
import com.ruoyi.common.utils.DateUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.system.mapper.YqszhCbMapper;
import com.ruoyi.system.domain.YqszhCb;
import com.ruoyi.system.service.IYqszhCbService;

/**
 * 油气数智化-产品Service业务层处理
 *
 * @author ruoyi
 * @date 2024-10-23
 */
@Service
public class YqszhCbServiceImpl implements IYqszhCbService
{
    @Autowired
    private YqszhCbMapper yqszhCbMapper;

    /**
     * 查询油气数智化-产品
     *
     * @param id 油气数智化-产品主键
     * @return 油气数智化-产品
     */
    @Override
    public YqszhCb selectYqszhCbById(Long id)
    {
        return yqszhCbMapper.selectYqszhCbById(id);
    }

    /**
     * 查询油气数智化-产品列表
     *
     * @param yqszhCb 油气数智化-产品
     * @return 油气数智化-产品
     */
    @Override
    public List<YqszhCb> selectYqszhCbList(YqszhCb yqszhCb)
    {
        return yqszhCbMapper.selectYqszhCbList(yqszhCb);
    }

    /**
     * 新增油气数智化-产品
     *
     * @param yqszhCb 油气数智化-产品
     * @return 结果
     */
    @Override
    public int insertYqszhCb(YqszhCb yqszhCb)
    {

        yqszhCb.setCpjj(new String(Base64.decode(yqszhCb.getCpjj())));
        yqszhCb.setGntd(new String(Base64.decode(yqszhCb.getGntd())));
        yqszhCb.setYycx(new String(Base64.decode(yqszhCb.getYycx())));
        yqszhCb.setYfjs(new String(Base64.decode(yqszhCb.getYfjs())));
        yqszhCb.setTdjs(new String(Base64.decode(yqszhCb.getTdjs())));
        yqszhCb.setFwts(new String(Base64.decode(yqszhCb.getFwts())));
        yqszhCb.setFwal(new String(Base64.decode(yqszhCb.getFwal())));
        yqszhCb.setCreateTime(DateUtils.getNowDate());
        return yqszhCbMapper.insertYqszhCb(yqszhCb);
    }

    /**
     * 修改油气数智化-产品
     *
     * @param yqszhCb 油气数智化-产品
     * @return 结果
     */
    @Override
    public int updateYqszhCb(YqszhCb yqszhCb)
    {
        if(yqszhCb.getCpjj() != null){
            yqszhCb.setCpjj(new String(Base64.decode(yqszhCb.getCpjj())));
        }
        if(yqszhCb.getGntd() != null){
            yqszhCb.setGntd(new String(Base64.decode(yqszhCb.getGntd())));
        }

        if(yqszhCb.getYycx() != null){
            yqszhCb.setYycx(new String(Base64.decode(yqszhCb.getYycx())));
        }

        if(yqszhCb.getYfjs() != null){
            yqszhCb.setYfjs(new String(Base64.decode(yqszhCb.getYfjs())));
        }

        if(yqszhCb.getTdjs() != null){
            yqszhCb.setTdjs(new String(Base64.decode(yqszhCb.getTdjs())));
        }

        if(yqszhCb.getFwts() != null){
            yqszhCb.setFwts(new String(Base64.decode(yqszhCb.getFwts())));
        }

        if(yqszhCb.getFwal() != null){
            yqszhCb.setFwal(new String(Base64.decode(yqszhCb.getFwal())));
        }

        yqszhCb.setUpdateTime(DateUtils.getNowDate());
        return yqszhCbMapper.updateYqszhCb(yqszhCb);
    }

    /**
     * 批量删除油气数智化-产品
     *
     * @param ids 需要删除的油气数智化-产品主键
     * @return 结果
     */
    @Override
    public int deleteYqszhCbByIds(Long[] ids)
    {
        return yqszhCbMapper.deleteYqszhCbByIds(ids);
    }

    /**
     * 删除油气数智化-产品信息
     *
     * @param id 油气数智化-产品主键
     * @return 结果
     */
    @Override
    public int deleteYqszhCbById(Long id)
    {
        return yqszhCbMapper.deleteYqszhCbById(id);
    }
}
