package com.ruoyi.web.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.system.domain.YqszhZb;
import com.ruoyi.system.service.IYqszhZbService;
import com.ruoyi.common.utils.poi.ExcelUtil;

/**
 * 油气数智化-分类Controller
 *
 * @author ruoyi
 * @date 2024-10-23
 */
@RestController
@RequestMapping("/system/zb")
public class YqszhZbController extends BaseController
{
    @Autowired
    private IYqszhZbService yqszhZbService;

    /**
     * 查询油气数智化-分类列表
     */
    @GetMapping("/list")
    public AjaxResult list(YqszhZb yqszhZb)
    {
        List<YqszhZb> list = yqszhZbService.selectYqszhZbList(yqszhZb);
        return success(list);
    }

    /**
     * 查询油气数智化-分类列表下拉框数据
     */
    @GetMapping("/listxlk")
    public AjaxResult listxlk(YqszhZb yqszhZb)
    {
        List<YqszhZb> list = yqszhZbService.selectZb(yqszhZb);
        return success(list);
    }

    /**
     * 导出油气数智化-分类列表
     */
    @Log(title = "油气数智化-分类", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, YqszhZb yqszhZb)
    {
        List<YqszhZb> list = yqszhZbService.selectYqszhZbList(yqszhZb);
        ExcelUtil<YqszhZb> util = new ExcelUtil<YqszhZb>(YqszhZb.class);
        util.exportExcel(response, list, "油气数智化-分类数据");
    }

    /**
     * 获取油气数智化-分类详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(yqszhZbService.selectYqszhZbById(id));
    }

    /**
     * 新增油气数智化-分类
     */
    @Log(title = "油气数智化-分类", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody YqszhZb yqszhZb)
    {
        return toAjax(yqszhZbService.insertYqszhZb(yqszhZb));
    }

    /**
     * 修改油气数智化-分类
     */
    @Log(title = "油气数智化-分类", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody YqszhZb yqszhZb)
    {
        return toAjax(yqszhZbService.updateYqszhZb(yqszhZb));
    }

    /**
     * 删除油气数智化-分类
     */
    @Log(title = "油气数智化-分类", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(yqszhZbService.deleteYqszhZbByIds(ids));
    }
}
