package com.ruoyi.web.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.system.domain.YqszhCb;
import com.ruoyi.system.service.IYqszhCbService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 油气数智化-产品Controller
 *
 * @author ruoyi
 * @date 2024-10-23
 */
@RestController
@RequestMapping("/system/cb")
public class YqszhCbController extends BaseController
{
    @Autowired
    private IYqszhCbService yqszhCbService;

    /**
     * 查询油气数智化-产品列表
     */
    @GetMapping("/list")
    public TableDataInfo list(YqszhCb yqszhCb)
    {
        startPage();
        List<YqszhCb> list = yqszhCbService.selectYqszhCbList(yqszhCb);
        return getDataTable(list);
    }

    /**
     * 导出油气数智化-产品列表
     */
    @Log(title = "油气数智化-产品", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, YqszhCb yqszhCb)
    {
        List<YqszhCb> list = yqszhCbService.selectYqszhCbList(yqszhCb);
        ExcelUtil<YqszhCb> util = new ExcelUtil<YqszhCb>(YqszhCb.class);
        util.exportExcel(response, list, "油气数智化-产品数据");
    }

    /**
     * 获取油气数智化-产品详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(yqszhCbService.selectYqszhCbById(id));
    }

    /**
     * 新增油气数智化-产品
     */
    @Log(title = "油气数智化-产品", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody YqszhCb yqszhCb)
    {
        return toAjax(yqszhCbService.insertYqszhCb(yqszhCb));
    }

    /**
     * 修改油气数智化-产品
     */
    @Log(title = "油气数智化-产品", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody YqszhCb yqszhCb)
    {
        return toAjax(yqszhCbService.updateYqszhCb(yqszhCb));
    }

    /**
     * 删除油气数智化-产品
     */
    @Log(title = "油气数智化-产品", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(yqszhCbService.deleteYqszhCbByIds(ids));
    }
}
