package yangtz.cs.liu.wechat.vo.attendance;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class SchoolEducationVO {
    /** 学生id */
    @NotNull(message = "学生id不能为空")
    private Long studentId;

    /*
     * 学生名字
     * */
    private String studentName;

    /*
     * 总分
     * */
    @Excel(name = "总分")
    private Integer totalscore;

    /** 得分 */
    @Excel(name = "得分")
    private Integer score;

    /** 日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "日期不能为空")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date patrolDate;

    /*
     * 事件描述
     * */
    @Excel(name = "事件描述")
    @NotBlank(message = "描述不能为空")
    private String remarks;


    /*
    * 具体的打分详情
    * */
    @Excel(name = "具体的打分详情")
    private List<SchoolEducationDetailsVO> schoolEducationDetailsVO;
}
