package yangtz.cs.liu.wechat.service.impl.attendance;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.parameters.P;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherAttendance;
import yangtz.cs.liu.campus.mapper.teacher.SchoolTeacherAttendanceMapper;
import yangtz.cs.liu.wechat.service.attendance.IAttendanceService;
import yangtz.cs.liu.wechat.vo.attendance.TeacherAttendanceVO;
import yangtz.cs.liu.wechat.vo.attendance.TeacherSignVO;

import javax.xml.crypto.Data;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service
public class AttendanceServiceImpl extends ServiceImpl<SchoolTeacherAttendanceMapper, SchoolTeacherAttendance> implements IAttendanceService {

    @Autowired
    private SchoolTeacherAttendanceMapper attendanceMapper;

    /*
     * 显示本月或本年出勤天数
     * */
    @Override
    public TeacherAttendanceVO getAttendanceDetails(TeacherAttendanceVO attendanceVO) {
//        查询年就传2022-0  查询月就传2022-10   当月就传 0-0
        TeacherAttendanceVO teacherAttendanceVO = judgRange(attendanceVO);
//        获取出勤的记录
        List<SchoolTeacherAttendance> attendanceDays = attendanceMapper.getAttendanceList(teacherAttendanceVO);
//        设置出勤的天数
        attendanceVO.setAttendanceDays(attendanceDays.size());
//          获取未出勤和补录的列表(应该是占少数)
        List<SchoolTeacherAttendance> unAttendanceDays = attendanceMapper.getUnAttendanceList(attendanceVO);
        // 如何判断是 未签到 和 补录 有四个字段
        //未出勤的列表
        List<SchoolTeacherAttendance> unAttendanceList = new ArrayList<>();
        //补录列表
        List<SchoolTeacherAttendance> appendList = new ArrayList<>();

        if (unAttendanceDays.size() == 0) {
            attendanceVO.setUnAttendanceDays(0);
            return attendanceVO;
        }
        for (SchoolTeacherAttendance a : unAttendanceList) {
            if (a.getAttendanceAmInType() == "2" || a.getAttendanceAmOutType() == "2" || a.getAttendancePmInType() == "2" || a.getAttendancePmOutType() == "2") {
                unAttendanceList.add(a);
            } else {
                appendList.add(a);
            }
        }
        //设置未出勤的天数
        attendanceVO.setUnAttendanceDays(unAttendanceList.size());
        return attendanceVO;
    }

    /*
     * 获取出勤任务页面的显示
     * */
    @Override
    public TeacherAttendanceVO getAttendanceTask(TeacherAttendanceVO attendanceVO) {
        TeacherAttendanceVO attendanceDetails = getAttendanceDetails(attendanceVO);
        Date date = new Date();
        SchoolTeacherAttendance schoolTeacherAttendance = new SchoolTeacherAttendance();
        schoolTeacherAttendance.setAttendanceTime(date);
        schoolTeacherAttendance.setOpenId(attendanceVO.getOpenId());
        SchoolTeacherAttendance attendanceInfo = attendanceMapper.getAttendanceInfo(schoolTeacherAttendance);
        attendanceDetails.setSchoolTeacherAttendance(attendanceInfo);
        return attendanceDetails;
    }

    /*
     * 获取历史出勤任务列表
     * */
    @Override
    public List<SchoolTeacherAttendance> getAttendanceHistories(TeacherAttendanceVO attendanceVO) {
        TeacherAttendanceVO teacherAttendanceVO = judgRange(attendanceVO);
        List<SchoolTeacherAttendance> attendanceList = attendanceMapper.getAttendanceList(teacherAttendanceVO);
        return attendanceList;
    }

    /*
     * 获取当天的考勤信息
     * */
    @Override
    public TeacherSignVO getToDayAttendance(SchoolTeacherAttendance attendance) {
        SchoolTeacherAttendance attendanceInfo = attendanceMapper.getAttendanceInfo(attendance);
        if(StringUtils.isNull(attendanceInfo)){
            attendanceMapper.insert(attendance);
        }
        TeacherSignVO teacherSignVO = attendanceMapper.getToDayAttendance(attendance);
        return teacherSignVO;
    }

    /*
     * 判断是根据年还是月，还是当月
     * */
    public TeacherAttendanceVO judgRange(TeacherAttendanceVO attendanceVO) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        String[] split = attendanceVO.getResearchTime().split("-");

//        获取本月的开始时间和结束时间
        if (split[0].equals("0") && split[1].equals("0")) {
            cal.set(Calendar.DATE, 1);
            Date startTime = cal.getTime();
            attendanceVO.setStartTime(startTime);

            cal.set(Calendar.MONTH, cal.get(Calendar.MONTH) + 1);
            cal.set(Calendar.DATE, 1);
            Date endTime = cal.getTime();
            attendanceVO.setEndTime(endTime);
        } else if (split[1].equals("0")) {
//        获取查询年的开始时间和结束时间
            cal.set(Calendar.YEAR, Integer.parseInt(split[0]));
            cal.set(Calendar.MONTH, 0);
            cal.set(Calendar.DATE, 1);
            Date startTime = cal.getTime();
            attendanceVO.setStartTime(startTime);

            cal.set(Calendar.YEAR, Integer.parseInt(split[0]));
            cal.set(Calendar.MONTH, 1);
            cal.set(Calendar.DATE, 1);
            Date endTime = cal.getTime();
            attendanceVO.setEndTime(endTime);
        } else {
//            获取查询月的开始时间和结束时间
            cal.set(Calendar.YEAR, Integer.parseInt(split[0]));
            cal.set(Calendar.MONTH, Integer.parseInt(split[1]) - 1);
            cal.set(Calendar.DATE, 1);
            Date startTime = cal.getTime();
            attendanceVO.setStartTime(startTime);

            cal.set(Calendar.YEAR, Integer.parseInt(split[0]));
            cal.set(Calendar.MONTH, Integer.parseInt(split[1]));
            cal.set(Calendar.DATE, 1);
            Date endTime = cal.getTime();
            attendanceVO.setEndTime(endTime);
        }

        return attendanceVO;
    }
}
