package yangtz.cs.liu.wechat.service.impl.api;

import cn.hutool.json.JSONUtil;
import com.core.utils.HolidayDateUtil;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.http.HttpUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.temp.*;
import yangtz.cs.liu.wechat.domain.template.LeaveStateTemplate;
import yangtz.cs.liu.wechat.domain.template.LeaveTemplate;
import yangtz.cs.liu.wechat.domain.MsgTemplate;
import yangtz.cs.liu.wechat.domain.TemplateInfo;
import yangtz.cs.liu.wechat.domain.template.StudentLeaveTemplate;
import yangtz.cs.liu.wechat.service.api.IWxApiService;
import yangtz.cs.liu.wechat.utils.AccessTokenUtil;
import yangtz.cs.liu.wechat.utils.DateUtil;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author lyric
 * @date 2022/10/20 13:19
 */
@Service
public class WxApiServiceImpl implements IWxApiService {

    @Autowired
    private AccessTokenUtil accessTokenUtil;

    @Value("${template.leaveTemplateId}")
    private String leaveTemplateId;

    @Value("${template.leaveStateTemplateId}")
    private String leaveStateTemplateId;

    @Value("${template.teacherLeaveTemplateId}")
    private String teacherLeaveTemplateId;

    @Value("${template.leaveResultTemplateId}")
    private String leaveResultTemplateId;

    @Value("${template.studentLeaveTemplateId}")
    private String studentLeaveTemplateId;

    @Value("${template.purchaseTemplateId}")
    private String purchaseTemplateId;

    @Value("${template.officialTemplateId}")
    private String officialTemplateId;

    //    private static String templateId = "LQF_Uhn7-uY7XYhlx0N2D9mAZYNwhC9X7Rzp6ppH5ZA";
    //private static String templateId = "IHPndMRdTsO5zd4yC4K0yjtSw73QMrDiEqzsmbgJP2U";


//    @Override
//    public String sendTemplate(LeaveTemplate leaveTemplate) {
//        String toUserOpenId = leaveTemplate.getToUserOpenId();
//        String accessToken = accessTokenUtil.getToken();
////        String accessToken = "61_edJ7ajMBpoFL3LQYJQ-iG4uDI0iESpW2T2p3v2VYhCXjaJUFsWS7C9pOYqGHe3mZ741wum4JiuRifj-BIKJ8ylb0wlIqzUBFgo9I2M_SMeFkkLIwUnFjWdnQJ3O-a9fSxa_edck-1nFDqTsgQOOcACALJJ";
//        Map<String, TemplateInfo> data = new HashMap<>();
//        TemplateInfo first = new TemplateInfo("您有一个待审批事项", "#DC143C");
//        data.put("first", first);
//        TemplateInfo keyword1 = new TemplateInfo("请假申请", "#173177");
//        data.put("keyword1", keyword1);
//        TemplateInfo keyword2 = new TemplateInfo(leaveTemplate.getUserName(), "#173177");
//        data.put("keyword2", keyword2);
//        TemplateInfo keyword3 = new TemplateInfo(DateUtils.datePath(), "#173177");
//        data.put("keyword3", keyword3);
//        TemplateInfo keyword4 = new TemplateInfo("长江大学-5教116", "#222324");
//        data.put("keyword4", keyword4);
//        TemplateInfo remark = new TemplateInfo("请您尽快审批", "#DC143C");
//        data.put("remark", remark);
//
//        MsgTemplate template = new MsgTemplate();
//        template.setData(data);
//        template.setTemplate_id(templateId);
//        template.setUrl("www.baidu.com");
//        template.setTouser(toUserOpenId);
//        String jsonObject = JSONUtil.parseObj(template).toString();
//
//        String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken;
//        String result = HttpUtils.sendPost(sendUrl, jsonObject);
//        return result;
//    }

    @Override
    public String sendTemplate(LeaveTemplate leaveTemplate) {
        String toUserOpenId = leaveTemplate.getToUserOpenId();
        String accessToken = accessTokenUtil.getToken();
        Map<String, TemplateInfo> data = new HashMap<>();
        TemplateInfo first = new TemplateInfo("您有一个待审批的请假事项", "#DC143C");
        data.put("first", first);
        TemplateInfo keyword1 = new TemplateInfo(leaveTemplate.getIdentity() == 1 ? "老师" : "学生", "#173177");
        data.put("keyword1", keyword1);
        TemplateInfo keyword2 = new TemplateInfo(leaveTemplate.getUserName(), "#173177");
        data.put("keyword2", keyword2);
        TemplateInfo keyword3 = new TemplateInfo(DateUtils.datePath(), "#173177");
        data.put("keyword3", keyword3);
        TemplateInfo keyword4 = new TemplateInfo(leaveTemplate.getReasonForLeave(), "#222324");
        data.put("keyword4", keyword4);

        Date leaveStartTime = leaveTemplate.getLeaveStartTime();
        Date leaveEndTime = leaveTemplate.getLeaveEndTime();
        Double hours = DateUtil.getHoursBetween2Date(leaveStartTime, leaveEndTime);
        TemplateInfo keyword5 = new TemplateInfo();
        if (hours < 24.0) keyword5 = new TemplateInfo(hours + "小时", "#222324");
        else {
            Integer t1 = (int) (hours / 24);
            Double d2 = hours - 24 * t1;
            if (d2 == 0.0) keyword5 = new TemplateInfo(t1 + "天", "#222324");
            else keyword5 = new TemplateInfo(t1 + "天" + d2 + "小时", "#222324");
        }
        data.put("keyword5", keyword5);

        TemplateInfo remark = new TemplateInfo("请您尽快审批", "#DC143C");
        data.put("remark", remark);

        MsgTemplate template = new MsgTemplate();
        template.setData(data);
        template.setTemplate_id(leaveTemplateId);
        template.setUrl("www.baidu.com");
        template.setTouser(toUserOpenId);
        String jsonObject = JSONUtil.parseObj(template).toString();

        String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken;
        String result = HttpUtils.sendPost(sendUrl, jsonObject);
        return result;
    }

    /**
     *
     * @author lyric
     * @date 2022/11/16 14:51
     * @param leaveStateTemplate
     * @return String
     *
     * 请假消息模板
     */
    @Override
    public String sendLeaveStateTemplate(LeaveStateTemplate leaveStateTemplate) {
        String toUserOpenId = leaveStateTemplate.getToUserOpenId();
        String accessToken = accessTokenUtil.getToken();
        Map<String, TemplateInfo> data = new HashMap<>();
        TemplateInfo first = new TemplateInfo("您的请假事项已被审批", "#FFA500");
        data.put("first", first);
        TemplateInfo keyword1 = new TemplateInfo(leaveStateTemplate.getName() + (leaveStateTemplate.getIdentity() == 1 ? "老师" : "学生"), "#173177");
        data.put("keyword1", keyword1);
        TemplateInfo keyword2 = new TemplateInfo(leaveStateTemplate.getHandUserName(), "#173177");
        data.put("keyword2", keyword2);
        TemplateInfo keyword3 = new TemplateInfo(leaveStateTemplate.getHandTime(), "#173177");
        data.put("keyword3", keyword3);
        TemplateInfo keyword4 = new TemplateInfo(leaveStateTemplate.getState(), leaveStateTemplate.getState().equals("请求通过")?"#008000":"#FF0000");
        data.put("keyword4", keyword4);
        TemplateInfo keyword5 = new TemplateInfo(leaveStateTemplate.getComment(), "#173177");
        data.put("keyword5", keyword5);

        TemplateInfo remark = new TemplateInfo("", "#DC143C");
        data.put("remark", remark);

        MsgTemplate template = new MsgTemplate();
        template.setData(data);
        template.setTemplate_id(leaveStateTemplateId);
        template.setUrl("www.baidu.com");
        template.setTouser(toUserOpenId);
        String jsonObject = JSONUtil.parseObj(template).toString();

        String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken;
        String result = HttpUtils.sendPost(sendUrl, jsonObject);
        return result;
    }

    @Override
    public String sendTeacherLeaveTemplate(TeacherLeaveTemplate template) {
        String toUserOpenId = template.getToUserOpenId();
        String accessToken = accessTokenUtil.getToken();
        Map<String, TemplateInfo> data = new HashMap<>();
        TemplateInfo first = new TemplateInfo(template.getUserName()+"的请假申请需要您审批。", "#DC143C");
        data.put("first", first);
        //请假类型
        String leaveType = "";
        switch (Integer.parseInt(template.getType())){
            case 0 : leaveType = "公假";break;
            case 1 : leaveType = "事假";break;
            case 2 : leaveType = "病假";break;
            case 3 : leaveType = "婚假";break;
            case 4 : leaveType = "丧假";break;
            case 5 : leaveType = "产假";break;
            default: leaveType = "其他";break;
        }
        TemplateInfo keyword1 = new TemplateInfo(leaveType, "#173177");
        data.put("keyword1", keyword1);
        Date leaveStartTime = template.getLeaveStartTime();
        Date leaveEndTime = template.getLeaveEndTime();
        String start = "";
        String end = "";
        //请假开始时间、结束时间
        //教工
        if("0".equals(template.getUserType())){
            start = HolidayDateUtil.format.format(template.getLeaveStartTime()) +" 第" + template.getStartSort() + "节课";
            end = HolidayDateUtil.format.format(template.getLeaveEndTime()) +" 第" + template.getEndSort() + "节课";

        }else{
            //教工
            start = HolidayDateUtil.format.format(template.getLeaveStartTime());
            end = HolidayDateUtil.format.format(template.getLeaveEndTime());
        }
        //开始时间
        TemplateInfo keyword2 = new TemplateInfo(start, "#173177");
        data.put("keyword2", keyword2);
        //结束时间
        TemplateInfo keyword3 = new TemplateInfo(end, "#173177");
        data.put("keyword3", keyword3);
        TemplateInfo remark = new TemplateInfo("共计" + template.getTotalTime() +"天，请您尽快处理", "#DC143C");
        data.put("remark", remark);

        MsgTemplate msgTemplate = new MsgTemplate();
        msgTemplate.setData(data);
        msgTemplate.setTemplate_id(teacherLeaveTemplateId);
//        msgTemplate.setUrl("www.baidu.com");
        msgTemplate.setTouser(toUserOpenId);
        String jsonObject = JSONUtil.parseObj(template).toString();

        String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken;
        String result = HttpUtils.sendPost(sendUrl, jsonObject);
        return result;
    }

    @Override
    public String sendLeaveResultTemplate(LeaveResultTemplate template) {
        String toUserOpenId = template.getToUserOpenId();
        String accessToken = accessTokenUtil.getToken();
        Map<String, TemplateInfo> data = new HashMap<>();
        TemplateInfo first = new TemplateInfo(template.getFirst(), "#DC143C");
        data.put("first", first);
        TemplateInfo keyword1 = new TemplateInfo(template.getResult(), "#173177");
        data.put("keyword1", keyword1);
        //审核时间
        String end = HolidayDateUtil.format.format(template.getAuditTime());
        TemplateInfo keyword2 = new TemplateInfo(end, "#173177");
        data.put("keyword2", keyword2);
        TemplateInfo remark = new TemplateInfo(template.getRemark(), "#DC143C");
        data.put("remark", remark);

        MsgTemplate msgTemplate = new MsgTemplate();
        msgTemplate.setData(data);
        msgTemplate.setTemplate_id(leaveResultTemplateId);
//        msgTemplate.setUrl("www.baidu.com");
        msgTemplate.setTouser(toUserOpenId);
        String jsonObject = JSONUtil.parseObj(template).toString();

        String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken;
        String result = HttpUtils.sendPost(sendUrl, jsonObject);
        return result;
    }

    @Override
    public String sendStudentLeaveTemplate(StudentLeaveTemplate template) {
        String toUserOpenId = template.getToUserOpenId();
        String accessToken = accessTokenUtil.getToken();
        Map<String, TemplateInfo> data = new HashMap<>();
        TemplateInfo first = new TemplateInfo(template.getFirst(), "#DC143C");
        data.put("first", first);
        TemplateInfo keyword1 = new TemplateInfo(template.getClassName(), "#173177");
        data.put("keyword1", keyword1);
        TemplateInfo keyword2 = new TemplateInfo(template.getStudentName(), "#173177");
        data.put("keyword2", keyword2);
        //离校时间
        String start = HolidayDateUtil.format.format(template.getLeaveStartTime());
        //回校时间
        String end = HolidayDateUtil.format.format(template.getLeaveEndTime());
        TemplateInfo keyword3 = new TemplateInfo(start, "#173177");
        data.put("keyword3", keyword3);
        //结束时间
        TemplateInfo keyword4 = new TemplateInfo(end, "#173177");
        data.put("keyword4", keyword4);

        //请假类型
        String leaveType = "";
        switch (Integer.parseInt(template.getType())){
            case 0 : leaveType = "公假";break;
            case 1 : leaveType = "事假";break;
            case 2 : leaveType = "病假";break;
            case 3 : leaveType = "婚假";break;
            case 4 : leaveType = "丧假";break;
            case 5 : leaveType = "产假";break;
            default: leaveType = "其他";break;
        }
        TemplateInfo keyword5 = new TemplateInfo(leaveType, "#173177");
        data.put("keyword5", keyword5);

        TemplateInfo remark = new TemplateInfo("请假原因：" + template.getReasonForLeave() , "#DC143C");
        data.put("remark", remark);

        MsgTemplate msgTemplate = new MsgTemplate();
        msgTemplate.setData(data);
        msgTemplate.setTemplate_id(studentLeaveTemplateId);
//        msgTemplate.setUrl("www.baidu.com");
        msgTemplate.setTouser(toUserOpenId);
        String jsonObject = JSONUtil.parseObj(template).toString();

        String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken;
        String result = HttpUtils.sendPost(sendUrl, jsonObject);
        return result;
    }

    @Override
    public String sendPurchaseTemplate(PurchaseTemplate template) {
        String toUserOpenId = template.getToUserOpenId();
        String accessToken = accessTokenUtil.getToken();
        Map<String, TemplateInfo> data = new HashMap<>();
        TemplateInfo first = new TemplateInfo(template.getFirst(), "#DC143C");
        data.put("first", first);
        TemplateInfo keyword1 = new TemplateInfo(template.getApplyUser(), "#173177");
        data.put("keyword1", keyword1);
        TemplateInfo keyword2 = new TemplateInfo(template.getContent(), "#173177");
        data.put("keyword2", keyword2);
        //申请时间
        String applyTime = HolidayDateUtil.format.format(template.getApplyTime());
        TemplateInfo keyword3 = new TemplateInfo(applyTime, "#173177");
        data.put("keyword3", keyword3);

        TemplateInfo remark = new TemplateInfo( template.getRemark() , "#DC143C");
        data.put("remark", remark);

        MsgTemplate msgTemplate = new MsgTemplate();
        msgTemplate.setData(data);
        msgTemplate.setTemplate_id(purchaseTemplateId);
//        msgTemplate.setUrl("www.baidu.com");
        msgTemplate.setTouser(toUserOpenId);
        String jsonObject = JSONUtil.parseObj(template).toString();

        String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken;
        String result = HttpUtils.sendPost(sendUrl, jsonObject);
        return result;
    }

    @Override
    public String sendAuditoriumTemplate(AuditoriumTemplate template) {
        String toUserOpenId = template.getToUserOpenId();
        String accessToken = accessTokenUtil.getToken();
        Map<String, TemplateInfo> data = new HashMap<>();
        TemplateInfo first = new TemplateInfo(template.getFirst(), "#DC143C");
        data.put("first", first);
        TemplateInfo keyword1 = new TemplateInfo(template.getApplyUser(), "#173177");
        data.put("keyword1", keyword1);
        TemplateInfo keyword2 = new TemplateInfo(template.getContent(), "#173177");
        data.put("keyword2", keyword2);
        //申请时间
        String applyTime = HolidayDateUtil.format.format(template.getApplyTime());
        TemplateInfo keyword3 = new TemplateInfo(applyTime, "#173177");
        data.put("keyword3", keyword3);

        TemplateInfo remark = new TemplateInfo( template.getRemark() , "#DC143C");
        data.put("remark", remark);

        MsgTemplate msgTemplate = new MsgTemplate();
        msgTemplate.setData(data);
        msgTemplate.setTemplate_id(purchaseTemplateId);
//        msgTemplate.setUrl("www.baidu.com");
        msgTemplate.setTouser(toUserOpenId);
        String jsonObject = JSONUtil.parseObj(template).toString();

        String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken;
        String result = HttpUtils.sendPost(sendUrl, jsonObject);
        return result;
    }

    @Override
    public String sendDepartmentBudgetTemplate(DepartmentBudgetTemplate template) {
        String toUserOpenId = template.getToUserOpenId();
        String accessToken = accessTokenUtil.getToken();
        Map<String, TemplateInfo> data = new HashMap<>();
        TemplateInfo first = new TemplateInfo(template.getFirst(), "#DC143C");
        data.put("first", first);
        TemplateInfo keyword1 = new TemplateInfo(template.getApplyUser(), "#173177");
        data.put("keyword1", keyword1);
        TemplateInfo keyword2 = new TemplateInfo(template.getContent(), "#173177");
        data.put("keyword2", keyword2);
        //申请时间
        String applyTime = HolidayDateUtil.format.format(template.getApplyTime());
        TemplateInfo keyword3 = new TemplateInfo(applyTime, "#173177");
        data.put("keyword3", keyword3);

        TemplateInfo remark = new TemplateInfo( template.getRemark() , "#DC143C");
        data.put("remark", remark);

        MsgTemplate msgTemplate = new MsgTemplate();
        msgTemplate.setData(data);
        msgTemplate.setTemplate_id(purchaseTemplateId);
//        msgTemplate.setUrl("www.baidu.com");
        msgTemplate.setTouser(toUserOpenId);
        String jsonObject = JSONUtil.parseObj(template).toString();

        String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken;
        String result = HttpUtils.sendPost(sendUrl, jsonObject);
        return result;
    }

    @Override
    public String sendOfficalTemplate(OfficalTemplate template) {
        String toUserOpenId = template.getToUserOpenId();
        String accessToken = accessTokenUtil.getToken();
        Map<String, TemplateInfo> data = new HashMap<>();
        TemplateInfo first = new TemplateInfo(template.getFirst(), "#DC143C");
        data.put("first", first);
        TemplateInfo keyword1 = new TemplateInfo(template.getTitle(), "#173177");
        data.put("keyword1", keyword1);
        //办结时间
        String applyTime = HolidayDateUtil.format1.format(template.getFinishTime());
        TemplateInfo keyword2 = new TemplateInfo(applyTime, "#173177");
        data.put("keyword2", keyword2);

        TemplateInfo keyword3 = new TemplateInfo(template.getContent(), "#173177");
        data.put("keyword3", keyword3);

        TemplateInfo remark = new TemplateInfo( template.getRemark() , "#DC143C");
        data.put("remark", remark);

        MsgTemplate msgTemplate = new MsgTemplate();
        msgTemplate.setData(data);
        msgTemplate.setTemplate_id(officialTemplateId);
//        msgTemplate.setUrl("www.baidu.com");
        msgTemplate.setTouser(toUserOpenId);
        String jsonObject = JSONUtil.parseObj(template).toString();

        String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken;
        String result = HttpUtils.sendPost(sendUrl, jsonObject);
        return result;
    }
}
