package yangtz.cs.liu.wechat.service.attendance;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherAttendance;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class TeacherSignVO {

    /*
    * 考勤记录id
    * */
    private Long id;

    /*
    * 老师姓名
    * */
    private String teacherName;


    /**
     * 出勤日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "出勤日期不能为空")
    @Excel(name = "出勤日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date attendanceTime;
}
