package yangtz.cs.liu.wechat.controller.teacher;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherDuty;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherDutyService;

import java.util.List;

/**
 * @author lyric
 * @date 2022/11/20 9:33
 */
@RestController
@RequestMapping("/wx/teacherDuty")
public class WxSchoolTeacherDutyController extends BaseController {

    @Autowired
    private ISchoolTeacherDutyService schoolTeacherDutyService;

    /**
     * @author lyric
     * @date 2022/11/20 9:34
     * 我的值班列表
     */
    @GetMapping("/dutyList/{teacherId}")
    public TableDataInfo dutyList(@PathVariable("teacherId") Long teacherId, SchoolTeacherDuty schoolTeacherDuty) {
        startPage();
        schoolTeacherDuty.setTeacherId(teacherId);
        List<SchoolTeacherDuty> list = schoolTeacherDutyService.queryList(schoolTeacherDuty);
        return getDataTable(list);
    }

    /**
     *
     * @author lyric
     * @date 2022/11/20 15:08
     * 值班详情
     */
    @GetMapping("/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolTeacherDutyService.getById(id));
    }

}
