package yangtz.cs.liu.wechat.controller.student;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.SchoolStudentIntegral.SchoolStudentIntegral;
import yangtz.cs.liu.campus.service.ISchoolStudentIntegra.ISchoolStudentIntegralService;

import java.util.Calendar;
import java.util.List;

@RestController
@RequestMapping("/wx/integral")
public class WxSchoolStudentIntegralController extends BaseController {
    @Autowired
    private ISchoolStudentIntegralService integralService;
    //级部
    public static final String GRADELEVEL = "0";
    //班级
    public static final String CLASSLEVEL = "1";
    //惩罚
    public static final String NOREWARD = "0";
    //奖励
    public static final String REWARD = "1";

    /**
     * 查询某学生某学年   当前学期积分列表
     * 前端传个学年，学生id
     */
    //@PreAuthorize("@ss.hasPermi('system:integral:list')")
    @GetMapping("/list/{studentId}")
    public AjaxResult list(@PathVariable Long studentId, SchoolStudentIntegral schoolStudentIntegral)
    {

        //获取当前学年，所在学期
        int term = isNewTerm();
        int schoolYear = getNewYear();
        schoolStudentIntegral.setStudentId(studentId);
        schoolStudentIntegral.setTerm(term);
        schoolStudentIntegral.setSchoolYear(schoolYear);
        //该学生本学年当前学期积分列表
        List<SchoolStudentIntegral> list = integralService.selectSchoolStudentIntegralList(schoolStudentIntegral);
        AjaxResult ajax = AjaxResult.success(list);

        //班级得分 classScore
        // ，级部得分，gradeScore
        // 综合得分 sum
        double classScore = 0.0;
        double gradeScore = 0.0;
        double sum = 100.0;
        if(StringUtils.isNotNull(list) && list.size() > 0){
            for(SchoolStudentIntegral integral :list){
                //级部
                if(integral.getLevel().equals(GRADELEVEL)){
                    //惩罚
                    if(integral.getIsReward().equals(NOREWARD)){
                        gradeScore = gradeScore - integral.getScore();
                        sum = sum - integral.getScore();
                    }else {
                        //奖励
                        gradeScore = gradeScore + integral.getScore();
                        sum = sum + integral.getScore();
                    }
                }else {
                    //班级
                    //惩罚
                    if(integral.getIsReward().equals(NOREWARD)){
                        classScore = classScore - integral.getScore();
                        sum = sum - integral.getScore();
                    }else {
                        //奖励
                        classScore = classScore + integral.getScore();
                        sum = sum + integral.getScore();
                    }
                }
            }
        }
        ajax.put("classScore",classScore);
        ajax.put("gradeScore",gradeScore);
        ajax.put("sum",sum);
        return ajax;
    }

    private Integer isNewTerm() {
        Calendar cal = Calendar.getInstance();
        //获取当前年月
        int month = cal.get(Calendar.MONTH) + 1;
        //设置当前学期为上学期
        int term = 0;
        //2-7为下学期，8-1为上学期
        if (month >= 2 && month < 8) {
            term = 1;
        }
        return term;
    }

    public int getNewYear(){
        Calendar cal = Calendar.getInstance();
        //获取当前年月
        int nowYear = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        //设置当前学期
        int term = 1;
        //2-7为第二学期，8-1为第一学期
        //如果当前月份小于8月，则该学年应为当前年-1 到 当前年,例如当前年月为2023年7月，则该学年为2022-2023年的第二学期
        if (month < 8) {
            nowYear = nowYear - 1;
        }
        if (month >= 2 && month < 8) {
            term = 2;
        }
        return nowYear;
    }
}
