package yangtz.cs.liu.wechat.controller.student;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.student.SchoolStudentEvaluate;
import yangtz.cs.liu.campus.service.student.ISchoolStudentEvaluateService;
import yangtz.cs.liu.wechat.vo.student.SchoolStudentEvaluateVo;

import java.util.List;

@RestController
@RequestMapping("/wx/evaluate")
public class WxSchoolStudentEvaluateController extends BaseController {

    @Autowired
    private ISchoolStudentEvaluateService schoolStudentEvaluateService;

    /**
     * 学生综合素质评价列表
     *
     * @param schoolStudentEvaluate
     * @return
     */
    @GetMapping("/list/{studentId}")
    public TableDataInfo list(@PathVariable("studentId") Long studentId, SchoolStudentEvaluate schoolStudentEvaluate) {
        schoolStudentEvaluate.setStudentId(studentId);
        startPage();
        List<SchoolStudentEvaluate> list = schoolStudentEvaluateService.queryList(schoolStudentEvaluate);
        return getDataTable(list);
    }

    /**
     * 家长端获取老师对学生的评价列表
     **/
    @GetMapping("/getEvaluate")
    public TableDataInfo getEvaluate(Long studentId) {
        startPage();
        List<SchoolStudentEvaluateVo> list = schoolStudentEvaluateService.getEvaluate(studentId);
        return getDataTable(list);
    }


    /**
     * 家长查询学生具体学期的素质评价
     *
     * @param id 学生素质评价表主键id
     * @return
     */
    @GetMapping("/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolStudentEvaluateService.getById(id));
    }


}
