package yangtz.cs.liu.wechat.controller.schoolxxfb;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfb;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfbRy;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfbTt;
import yangtz.cs.liu.campus.service.schoolXxfb.ISchoolXxfbRyService;
import yangtz.cs.liu.campus.service.schoolXxfb.ISchoolXxfbService;
import yangtz.cs.liu.campus.service.schoolXxfb.ISchoolXxfbTtService;
import yangtz.cs.liu.campus.vo.schoolXxfb.XxfbDataVo;
import yangtz.cs.liu.campus.vo.schoolXxfb.XxfbTitleVo;
import yangtz.cs.liu.wechat.vo.schoolXxfb.SchoolXxfbVo;

import java.util.*;
import java.util.stream.Collectors;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;

@RestController
@RequestMapping("/wx/schoolXxfb")
public class WxSchoolXxfbController extends BaseController {

    @Autowired
    private ISchoolXxfbService schoolXxfbService;

    @Autowired
    private ISchoolXxfbTtService schoolXxfbTtService;

    @Autowired
    private ISchoolXxfbRyService schoolXxfbRyService;

    @Autowired
    private UserInfoUtil userInfoUtil;

    public static final String PUBLISH = "2"; //发布

    /*
    获取信息发主列表（前端页面判断是否反馈，根据传过去的fk值，fk为空，则未反馈）
     */
    @GetMapping("/getList")
    public TableDataInfo getList(){
        startPage();
        List<SchoolXxfbVo> list = schoolXxfbService.getList(userInfoUtil.getStudentId());
        List<SchoolXxfbVo> schoolXxfbVoList = new ArrayList<>();
        for (SchoolXxfbVo schoolXxfbVo : list) {
            if (schoolXxfbVo.getXxfbZt().equals(PUBLISH)){
                schoolXxfbVoList.add(schoolXxfbVo);
            }
        }
//        List<SchoolXxfbVo> collect = list.stream()
//                .sorted(Comparator.comparing(SchoolXxfbVo::getCreateTime))
//                .filter(x->x.getXxfbZt().equals(PUBLISH))   //只能看到发布的信息
//                .collect(Collectors.toList());
        if (schoolXxfbVoList.isEmpty()){ //如果没有数据，直接返回null完事
            return getDataTable(new ArrayList<>());
        }
        return getDataTable(schoolXxfbVoList);
    }

    /*
    查看信息发布
     */
    @GetMapping("/survey/{xxfbId}")
    public AjaxResult survey(@PathVariable("xxfbId") Long xxfbId){
        //传表头，及其对应内容
        LambdaQueryWrapper<SchoolXxfbTt> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolXxfbTt::getXxfbId, xxfbId)
                .orderByAsc(SchoolXxfbTt::getTtXh)
        ;
        List<SchoolXxfbTt> ttList = schoolXxfbTtService.list(lqw);
        XxfbTitleVo titleVo = schoolXxfbTtService.turnTitle(ttList);
        Map<String, String> map = schoolXxfbRyService.handle(titleVo, xxfbId, userInfoUtil.getStudentId());
        //查询一次，查询次数+1
        LambdaUpdateWrapper<SchoolXxfb> luq = new LambdaUpdateWrapper<>();
        luq.eq(SchoolXxfb::getId, xxfbId).setSql(" num = num+1 ");
        schoolXxfbService.update(luq);

        LambdaQueryWrapper<SchoolXxfbRy> ryLqw = new LambdaQueryWrapper<>();
        ryLqw
                .eq(SchoolXxfbRy::getXxfbId, xxfbId)
                .eq(isNotNull(userInfoUtil.getStudentId()),SchoolXxfbRy::getStudentId,userInfoUtil.getStudentId())
        ;
        SchoolXxfbRy schoolXxfbRy = schoolXxfbRyService.getOne(ryLqw);
        schoolXxfbRy.setRyCksj(new Date());
        schoolXxfbRyService.updateById(schoolXxfbRy);
        //schoolXxfbRy.setRyTjsj(new Date());
        map.put("ryFk", schoolXxfbRy.getRyFk());

        return AjaxResult.success(map);
    }


    /**
     * 提交
     * @param xxfbId
     * @param ryFk  反馈
     * @return
     */
    @PostMapping("/commit/{xxfbId}")
    public AjaxResult commit(@PathVariable("xxfbId") Long xxfbId,String ryFk){
        LambdaQueryWrapper<SchoolXxfbRy> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolXxfbRy::getXxfbId, xxfbId)
                .eq(isNotNull(userInfoUtil.getStudentId()),SchoolXxfbRy::getStudentId,userInfoUtil.getStudentId())
        ;
        SchoolXxfbRy schoolXxfbRy = schoolXxfbRyService.getOne(lqw);
        schoolXxfbRy.setRyFk(ryFk);
        //schoolXxfbRy.setRyCksj(new Date());
        schoolXxfbRy.setRyTjsj(new Date());
        return AjaxResult.success(schoolXxfbRyService.updateById(schoolXxfbRy));
    }


}
