package yangtz.cs.liu.wechat.controller.schoolResource;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.resources.SchoolResources;
import yangtz.cs.liu.campus.domain.resources.SchoolResourcesDetails;
import yangtz.cs.liu.campus.domain.resources.SchoolResourcesDetailsComment;
import yangtz.cs.liu.campus.service.resources.ISchoolResourcesDetailsCommentService;
import yangtz.cs.liu.campus.service.resources.ISchoolResourcesDetailsService;
import yangtz.cs.liu.campus.service.resources.ISchoolResourcesService;
import yangtz.cs.liu.campus.vo.resource.SchoolResourcesDetailsVo;
import yangtz.cs.liu.wechat.vo.schoolResource.SchoolResourcesDetailsCommentVo;

import java.util.HashMap;
import java.util.List;

@RestController
@RequestMapping("/wx/schoolResource")
public class WxSchoolResourceController extends BaseController {

    @Autowired
    private ISchoolResourcesService schoolResourcesService;

    @Autowired
    private ISchoolResourcesDetailsService schoolResourcesDetailsService;

    @Autowired
    private ISchoolResourcesDetailsCommentService schoolResourcesDetailsCommentService;


    /**
     * 获取学校资源
     *
     * @return
     */
    @GetMapping("/getResource")
    public TableDataInfo getResource(SchoolResources schoolResources) {
        startPage();
        List<SchoolResources> schoolResourcesList = schoolResourcesService.queryList(schoolResources);
        return getDataTable(schoolResourcesList);
    }

    /**
     * 获取学校资源相关细节
     *
     * @return
     */
    @GetMapping("/getResouceDetails/{resourcesId}")
    public TableDataInfo getResouceDetails(@PathVariable("resourcesId") Long resourcesId, SchoolResourcesDetailsVo schoolResourcesDetails) {
        startPage();
        schoolResourcesDetails.setResourcesId(resourcesId);
        List<SchoolResourcesDetailsVo> schoolResourcesDetailsList = schoolResourcesDetailsService.queryList(schoolResourcesDetails);
        return getDataTable(schoolResourcesDetailsList);
    }

    /**
     * 查询资源细节
     *
     * @param id
     * @return
     */
    @GetMapping("/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolResourcesDetailsService.getById(id));
    }

    /**
     * 查询评论列表
     *
     * //TODO 按时间降序排 头像,用户名,评论时间,评论内容
     *
     * @param detailsId
     * @return
     */
    @GetMapping("/commentList/{detailsId}")
    public TableDataInfo commentList(@PathVariable("detailsId") Long detailsId) {
        List<SchoolResourcesDetailsCommentVo> commentListVo = schoolResourcesDetailsCommentService.getComment(detailsId);
        return getDataTable(commentListVo);
    }

    /**
     * 新增评论
     * @param schoolResourcesDetailsComment
     * @return
     */
    @PostMapping("/addComment")
    public AjaxResult addComment(@RequestBody @Validated SchoolResourcesDetailsComment schoolResourcesDetailsComment) {
        return AjaxResult.success(schoolResourcesDetailsCommentService.save(schoolResourcesDetailsComment));
    }

    /**
     * 更新点赞、收藏、下载
     * @param id
     * @param clickName
     * @return
     */
    @PostMapping("/updateAll")
    public AjaxResult updateAll(Long id,String clickName){
        HashMap<String, Object> map = new HashMap<>();
        map.put("id",id);
        map.put("clickName",clickName);
        return toAjax(schoolResourcesDetailsService.updateAll(map));
    }

    /**
     *
     * @author lyric
     * @date 2022/11/1 17:47
     *
     * 点赞 +1
     */
    @GetMapping("/updateThumbsUp/{id}")
    public AjaxResult updateThumbsUp(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolResourcesDetails> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolResourcesDetails::getId, id).setSql("thumbs_up = thumbs_up + 1");
        return toAjax(schoolResourcesDetailsService.update(luw));
    }

    /**
     *
     * @author lyric
     * @date 2022/11/1 17:47
     *
     * 收藏 +1
     */
    @GetMapping("/updateCollection/{id}")
    public AjaxResult updateCollection(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolResourcesDetails> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolResourcesDetails::getId, id).setSql("collection = collection + 1");
        return toAjax(schoolResourcesDetailsService.update(luw));
    }

    /**
     *
     * @author lyric
     * @date 2022/11/1 17:47
     *
     * 下载 +1
     */
    @GetMapping("/updateDownload/{id}")
    public AjaxResult updateDownload(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolResourcesDetails> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolResourcesDetails::getId, id).setSql("download = download + 1");
        return toAjax(schoolResourcesDetailsService.update(luw));
    }


}
