package yangtz.cs.liu.wechat.controller.schoolAtt;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.schoolAtt.SchoolAttEa;
import yangtz.cs.liu.campus.domain.schoolAtt.SchoolAttMon;
import yangtz.cs.liu.campus.domain.schoolAtt.SchoolAttOt;
import yangtz.cs.liu.campus.service.schoolAtt.ISchoolAttEaService;
import yangtz.cs.liu.campus.service.schoolAtt.ISchoolAttMonService;
import yangtz.cs.liu.campus.service.schoolAtt.ISchoolAttOtService;

import java.util.List;

@RestController
@RequestMapping("/wx/schoolAttMon")
public class WxSchoolAttMonController extends BaseController {

    @Autowired
    private ISchoolAttMonService monService;

    @Autowired
    private ISchoolAttEaService eaService;

    @Autowired
    private ISchoolAttOtService otService;


    /**
     * 个人查看月度考勤
     */
    @GetMapping("/personalList")
    public TableDataInfo personalList(SchoolAttMon schoolAttMon)
    {
        schoolAttMon.setUserId(schoolAttMon.getUserId());
        startPage();
        List<SchoolAttMon> list = monService.queryList(schoolAttMon);
        return getDataTable(list);
    }


    /**
     * 月度考勤 查看
     */
    @GetMapping("/getInfo/{attMonId}")
    public AjaxResult getInfo(@PathVariable Long attMonId)
    {
        AjaxResult ajax = AjaxResult.success();
        //获取考勤明细-请假
        List<SchoolAttEa> eaList = eaService.getListByAttMonId(attMonId);
        //获取考勤明细-加班
        List<SchoolAttOt> otList = otService.getListByAttMonId(attMonId);
        ajax.put("eaList",eaList);
        ajax.put("otList",otList);
        return ajax;
    }

}
