package yangtz.cs.liu.wechat.controller.schoolAssetsClaim;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.schoolAssetsClaim.SchoolAssetsClaim;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsOutService;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsService;
import yangtz.cs.liu.campus.service.schoolAssetsClaim.ISchoolAssetsClaimService;
import yangtz.cs.liu.campus.vo.schoolAssetsClaim.AssetsClaimListVo;
import yangtz.cs.liu.campus.vo.schoolAssetsClaim.SchoolAssetsClaimVo;

import java.util.List;

/**
 * @author Ego
 * @version 1.0
 * @date 2023/1/14 14:08
 */
@RestController
@RequestMapping("/wx/schoolAssetsClaim")
public class WxSchoolAssetsClaim extends BaseController {

    @Autowired
    private ISchoolAssetsClaimService schoolAssetsClaimService;

    @Autowired
    private UserInfoUtil userInfoUtil;
    /**
     * 查看个人领用记录
     */
    @PostMapping("/queryMyClaim")
    public TableDataInfo queryMyClaim(@RequestBody SchoolAssetsClaimVo schoolAssetsClaimVo) {
        //TODO 获取teacherId还是其他id
        Long userId = userInfoUtil.getTeacherId();
        List<AssetsClaimListVo> list = schoolAssetsClaimService.queryMyClaimList(userId,schoolAssetsClaimVo);
        return getDataTable(list);
    }
}
