package yangtz.cs.liu.wechat.controller.repairs;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.repairs.LogisticsRepairs;
import yangtz.cs.liu.campus.service.repairs.ILogisticsRepairsService;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/wx/repairs")
public class WxLogisticsRepairsController extends BaseController {

    @Autowired
    private ILogisticsRepairsService logisticsRepairsService;
    @Autowired
    private UserInfoUtil userInfoUtil;

    /**
     * 查看个人报修列表
     * @return
     */
    @GetMapping("/getList")
    public TableDataInfo getList(LogisticsRepairs logisticsRepairs){
        //TODO 获取teacherId还是其他id
        Long userId = userInfoUtil.getTeacherId();
        List<LogisticsRepairs> list = logisticsRepairsService.getList(userId,logisticsRepairs);
        return getDataTable(list);
    }

    /**
     * 查看报修详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(logisticsRepairsService.selectLogisticsRepairsById(id));
    }

    /**
     * 新增报修信息
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody LogisticsRepairs logisticsRepairs)
    {
        return toAjax(logisticsRepairsService.insertRepairs(logisticsRepairs));
    }

    /**
     * 修改报修信息
     */
    @PostMapping("/edit")
    public AjaxResult edit(@RequestBody LogisticsRepairs logisticsRepairs)
    {
        return toAjax(logisticsRepairsService.updateRepairs(logisticsRepairs));
    }

    /**
     * 删除后勤报修
     */
    @PostMapping("/remove/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(logisticsRepairsService.deleteLogisticsRepairsByIds(ids));
    }

    /**
     * 获取报修单号
     * @return
     */
    @GetMapping("/getNumber")
    public AjaxResult getNumber(){
        List<LogisticsRepairs> list = logisticsRepairsService.selectListRepairs(new LogisticsRepairs());
        //获取当前日期
        Date nowDate = DateUtils.getNowDate();
        SimpleDateFormat dateFormat= new SimpleDateFormat("yyyyMMdd");
        String format = dateFormat.format(nowDate);
        String number = format + "000001";
        long newNumber = Long.parseLong(number);
        for (LogisticsRepairs repairs : list) {
            if (newNumber == repairs.getId()){
                newNumber = repairs.getId() + 1;
            }
        }
        Map<String,Long> map = new HashMap<>();
        map.put("id",newNumber);
        return AjaxResult.success(map);
    }
}
