package yangtz.cs.liu.wechat.controller.courseSelection;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.AjaxResult;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.curricula.CurriclaStudentVo;
import yangtz.cs.liu.campus.domain.curricula.CurriculaStudent;
import yangtz.cs.liu.campus.domain.curricula.CurriculaVariable;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.service.curricula.ICurriculaStudentService;
import yangtz.cs.liu.campus.service.curricula.ICurriculaVariableService;
import yangtz.cs.liu.campus.service.curricula.IStudentScoreService;
import yangtz.cs.liu.campus.vo.curricula.CurriculaStudentVo;
import yangtz.cs.liu.campus.vo.student.SchoolStudentScoreVo;

/**
 * 公众号，选课
 */
@RestController
@RequestMapping("/wx/course")
public class WxCouresSelection {

  @Autowired
  IStudentScoreService iStudentScoreService;

  @Autowired
  ICurriculaStudentService iCurriculaStudentService;

  @Autowired
  ICurriculaVariableService iCurriculaVariableService;

  /**
   * 学生选号信息查询
   */
  @GetMapping("/getCourseInfo/{studentId}")
  private AjaxResult getCourseInfo(@PathVariable("studentId") Long studentId){
      //查询学生个人选课信息
    LambdaQueryWrapper<CurriculaStudent> wrapper = new LambdaQueryWrapper<>();
    wrapper.eq(CurriculaStudent::getStudentId,studentId);
    wrapper.eq(CurriculaStudent::getDelFlag,"0");
    //查询出学生任务信息
    CurriculaStudent one = iCurriculaStudentService.getOne(wrapper);
    //查询选课信息
    CurriculaVariable byId = iCurriculaVariableService.getById(one.getCurriculaId());
    CurriclaStudentVo data = new CurriclaStudentVo();
    //拼接返回对象
    BeanUtils.copyProperties(one,data);
    BeanUtils.copyProperties(byId,data);
    return AjaxResult.success(data);
  }


  /**
   * 学生成绩查询
   */
  @GetMapping("/achievement/{studentId}")
  private AjaxResult getStudentAchievements(@PathVariable("studentId") Long studentId){
    List<SchoolStudentScoreVo> schoolStudentScoreVos = iStudentScoreService
        .selectStudentScoreList(studentId);
    return AjaxResult.success(schoolStudentScoreVos);
  }

  /**
   * 据物理化类型查看
   */
  @GetMapping("/studenttypeview")
  private AjaxResult getStudentTypeview( CurriculaStudent curriculaStudent){
    List<SchoolStudentScoreVo> studentTypeViwe = iStudentScoreService
        .getStudentTypeViwe(curriculaStudent);
    return AjaxResult.success(studentTypeViwe);
  }


  /**
   * 保存选课信息
   */
  @PostMapping("/savestudentcourse")
  private AjaxResult saveStudentcourse(@RequestBody CurriculaStudent curriculaStudent){
    //保存专业信息
    try {
      iCurriculaStudentService.updateById(curriculaStudent);
      return AjaxResult.success("选课成功");
    }catch (Exception e){
      return AjaxResult.error("选课失败");
    }
  }


}
