package yangtz.cs.liu.wechat.controller.common;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.model.MpLoginUser;
import com.ruoyi.framework.util.UserInfoUtil;
import com.ruoyi.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.schoolAuthority.SchoolAuthority;
import yangtz.cs.liu.campus.service.purchase.ISchoolPurchaseService;
import yangtz.cs.liu.campus.service.schoolAuthority.ISchoolAuthorityService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentLeaveService;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherLeaveService;
import yangtz.cs.liu.wechat.domain.WxLoginBody;

import java.util.Calendar;

import static yangtz.cs.liu.wechat.constant.LoginTypeConstant.PARENT_LOGIN;

@RestController
@RequestMapping("/wx/common")
public class WxCommonController extends BaseController {

    @Autowired
    private ISchoolTeacherLeaveService schoolTeacherLeaveService;

    @Autowired
    private ISchoolPurchaseService schoolPurchaseService;

    @Autowired
    private ISchoolStudentLeaveService schoolStudentLeaveService;

    @Autowired
    private ISchoolAuthorityService schoolAuthorityService;

    @Autowired
    UserInfoUtil userInfoUtil;

    @Autowired
    private ISysUserService sysUserService;

    public static final String YES = "1";    //有权限


    @GetMapping("/getTerm")
    public AjaxResult isNewTerm() {
        Calendar cal = Calendar.getInstance();
        //获取当前年月
        int nowYear = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        //设置当前学期为上学期
        int term = 0;
        //2-7为下学期，8-1为上学期
        if (month >= 2 && month < 8) {
            term = 1;
        }
        return AjaxResult.success(term);
    }

    /**
     * 请假审批流程
     * @param id  school_teacher_leave 的id
     * @return
     */
    @GetMapping("/workFlows/{id}")
    public AjaxResult workFlows(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolTeacherLeaveService.workFlows(id));
    }

    /**
     * 办公审批流程
     * @param id  school_purchase 的id
     * @return
     */
     @GetMapping("/purchaseFlows/{id}")
     public AjaxResult purchaseFlows(@PathVariable("id") Long id) {
         return AjaxResult.success(schoolPurchaseService.purchaseFlows(id));
     }

    /**
     * 学生请假审批流程
     * @param id
     * @return
     */
    @GetMapping("/stduntLeavFlows/{id}")
    public AjaxResult stduntLeavFlows(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolStudentLeaveService.stduntLeavFlows(id));
    }

    /*
    判断用户是否有权限
     */
    @GetMapping("/judgePermission")
    public AjaxResult judgePermission(){
        MpLoginUser mpLoginUser = userInfoUtil.getMpLoginUser();
        SysUser user = sysUserService.selectUserById(mpLoginUser.getUserId());
        LambdaQueryWrapper<SchoolAuthority> lqw = new LambdaQueryWrapper<>();
        SchoolAuthority schoolAuthority = schoolAuthorityService.getOne(lqw);
        if (user.getUserLoginType().equals(PARENT_LOGIN)){  //家长登录
            if (schoolAuthority.getParent().equals(YES)){
                return AjaxResult.success(true);
            }else {
                return AjaxResult.success(false);
            }
        }else { //教职工登录
            if (schoolAuthority.getClassHeader().equals(YES)){
                return AjaxResult.success(true);
            }else {
                return AjaxResult.success(false);
            }
        }
    }


}
