package yangtz.cs.liu.wechat.controller.api;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Sha1Util {
    private static final int[] abcde = {
            0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0
    };
    // ժҪݴ洢
    private static int[] digestInt = new int[5];
    // еʱݴ洢
    private static int[] tmpData = new int[80];
    // sha-1ժҪ
    private static int process_input_bytes(byte[] bytedata) {
        // Ի
        System.arraycopy(abcde, 0, digestInt, 0, abcde.length);
        // ʽֽ飬10
        byte[] newbyte = byteArrayFormatData(bytedata);
        // ȡժҪݵԪ
        int MCount = newbyte.length / 64;
        // ѭÿݵԪժҪ
        for (int pos = 0; pos < MCount; pos++) {
            // ÿԪת16ݣ浽tmpDataǰ16Ԫ
            for (int j = 0; j < 16; j++) {
                tmpData[j] = byteArrayToInt(newbyte, (pos * 64) + (j * 4));
            }
            // ժҪ㺯
            encrypt();
        }
        return 20;
    }
    // ʽֽʽ
    private static byte[] byteArrayFormatData(byte[] bytedata) {
        // 0
        int zeros = 0;
        // λλ
        int size = 0;
        // ԭʼݳ
        int n = bytedata.length;
        // ģ64ʣλ
        int m = n % 64;
        // 0ĸԼ10ܳ
        if (m < 56) {
            zeros = 55 - m;
            size = n - m + 64;
        } else if (m == 56) {
            zeros = 63;
            size = n + 8 + 64;
        } else {
            zeros = 63 - m + 56;
            size = (n + 64) - m + 64;
        }
        // λɵ
        byte[] newbyte = new byte[size];
        // ǰ沿
        System.arraycopy(bytedata, 0, newbyte, 0, n);
        // AppendԪصλ
        int l = n;
        // 1
        newbyte[l++] = (byte) 0x80;
        // 0
        for (int i = 0; i < zeros; i++) {
            newbyte[l++] = (byte) 0x00;
        }
        // ݳȣݳλ8ֽڣ
        long N = (long) n * 8;
        byte h8 = (byte) (N & 0xFF);
        byte h7 = (byte) ((N >> 8) & 0xFF);
        byte h6 = (byte) ((N >> 16) & 0xFF);
        byte h5 = (byte) ((N >> 24) & 0xFF);
        byte h4 = (byte) ((N >> 32) & 0xFF);
        byte h3 = (byte) ((N >> 40) & 0xFF);
        byte h2 = (byte) ((N >> 48) & 0xFF);
        byte h1 = (byte) (N >> 56);
        newbyte[l++] = h1;
        newbyte[l++] = h2;
        newbyte[l++] = h3;
        newbyte[l++] = h4;
        newbyte[l++] = h5;
        newbyte[l++] = h6;
        newbyte[l++] = h7;
        newbyte[l++] = h8;
        return newbyte;
    }
    private static int f1(int x, int y, int z) {
        return (x & y) | (~x & z);
    }
    private static int f2(int x, int y, int z) {
        return x ^ y ^ z;
    }
    private static int f3(int x, int y, int z) {
        return (x & y) | (x & z) | (y & z);
    }
    private static int f4(int x, int y) {
        return (x << y) | x >>> (32 - y);
    }
    // ԪժҪ㺯
    private static void encrypt() {
        for (int i = 16; i <= 79; i++) {
            tmpData[i] = f4(tmpData[i - 3] ^ tmpData[i - 8] ^ tmpData[i - 14] ^
                    tmpData[i - 16], 1);
        }
        int[] tmpabcde = new int[5];
        for (int i1 = 0; i1 < tmpabcde.length; i1++) {
            tmpabcde[i1] = digestInt[i1];
        }
        for (int j = 0; j <= 19; j++) {
            int tmp = f4(tmpabcde[0], 5) +
                    f1(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] +
                    tmpData[j] + 0x5a827999;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
        }
        for (int k = 20; k <= 39; k++) {
            int tmp = f4(tmpabcde[0], 5) +
                    f2(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] +
                    tmpData[k] + 0x6ed9eba1;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
        }
        for (int l = 40; l <= 59; l++) {
            int tmp = f4(tmpabcde[0], 5) +
                    f3(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] +
                    tmpData[l] + 0x8f1bbcdc;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
        }
        for (int m = 60; m <= 79; m++) {
            int tmp = f4(tmpabcde[0], 5) +
                    f2(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] +
                    tmpData[m] + 0xca62c1d6;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
        }
        for (int i2 = 0; i2 < tmpabcde.length; i2++) {
            digestInt[i2] = digestInt[i2] + tmpabcde[i2];
        }
        for (int n = 0; n < tmpData.length; n++) {
            tmpData[n] = 0;
        }
    }
    // 4ֽתΪ
    private static int byteArrayToInt(byte[] bytedata, int i) {
        return ((bytedata[i] & 0xff) << 24) | ((bytedata[i + 1] & 0xff) << 16) |
                ((bytedata[i + 2] & 0xff) << 8) | (bytedata[i + 3] & 0xff);
    }
    // תΪ4ֽ
    private static void intToByteArray(int intValue, byte[] byteData, int i) {
        byteData[i] = (byte) (intValue >>> 24);
        byteData[i + 1] = (byte) (intValue >>> 16);
        byteData[i + 2] = (byte) (intValue >>> 8);
        byteData[i + 3] = (byte) intValue;
    }
    // ֽתΪʮַ
    private static String byteToHexString(byte ib) {
        char[] Digit = {
                '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C',
                'D', 'E', 'F'
        };
        char[] ob = new char[2];
        ob[0] = Digit[(ib >>> 4) & 0X0F];
        ob[1] = Digit[ib & 0X0F];
        String s = new String(ob);
        return s;
    }
    // ֽתΪʮַ
    private static String byteArrayToHexString(byte[] bytearray) {
        String strDigest = "";
        for (int i = 0; i < bytearray.length; i++) {
            strDigest += byteToHexString(bytearray[i]);
        }
        return strDigest;
    }
    // sha-1ժҪӦֽ
    public static byte[] getDigestOfBytes(byte[] byteData) {
        process_input_bytes(byteData);
        byte[] digest = new byte[20];
        for (int i = 0; i < digestInt.length; i++) {
            intToByteArray(digestInt[i], digest, i * 4);
        }
        return digest;
    }
    // sha-1ժҪӦʮַ
    public static String getDigestOfString(byte[] byteData) {
        return byteArrayToHexString(getDigestOfBytes(byteData));
    }





    /**
     * @Comment SHA1ʵ
     * @Author Ron
     * @Date 2017913 3:30:36
     * @return
     */
    public static String shaEncode(String inStr) throws Exception {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA");
        } catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }

        byte[] byteArray = inStr.getBytes("UTF-8");
        byte[] md5Bytes = sha.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; i++) {
            int val = ((int) md5Bytes[i]) & 0xff;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }





    public static void main(String[] args) {
        String[] array = {"fwwrr1223423ffff","VUkHJgW2SFNG4xhs6ZntSGDE-Z15MUTKs7pkKW7UnqMUv-GjswW5CWV38QXj_5-fRvEwyx842tP2j4Kw1HPE1Q","1617865042","pm4UL50ZAuQXDGihuENshhUWzIE8"};

        List<String> list = new ArrayList<String>();
        for(String str : array) {
            list.add(str);
        }
        String buff = "";
        Collections.sort(list,new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                // ֵΪintͣ0ʾС0ʾ
                Integer minLength = o1.length();
                if(minLength > o2.length()) {
                    minLength = o2.length();
                }
                for(int i=0;i<minLength;i++) {
                    char a = (char)o1.charAt(i);
                    char b = (char)o2.charAt(i);

                    if(a == b) {
                        continue;
                    }
                    if(a > b) {
                        return 1;
                    }else {
                        return -1;
                    }
                }
                return 0;
            }
        });

        for(String str : list) {
            buff += str;
        }

        System.out.println(buff);
        String data = "1617865042VUkHJgW2SFNG4xhs6ZntSGDE-Z15MUTKs7pkKW7UnqMUv-GjswW5CWV38QXj_5-fRvEwyx842tP2j4Kw1HPE1Qewwrr122342341223pm4UL50ZAuQXDGihuENshhUWzIE8";

        //3205FB63131DF9B9428FD90C09267F379E122356
        String digest = Sha1Util.getDigestOfString(data.getBytes()).toLowerCase();
        System.out.println(digest);
    }
}
