package yangtz.cs.liu.webpage.vo;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

/**
 * @author xuten
 */
@Data
public class WebSchoolArtStudentVo extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /** 姓名 */
    @Excel(name = "姓名")
    private String studentName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 学籍号 */
    @Excel(name = "学籍号")
    private String studentNumber;

    /** 初中学校id */
    @Excel(name = "初中学校id")
    private Long juniorId;
    private String schoolName;

    /** 测试项目id */
    @Excel(name = "测试项目id")
    private Long testId;
    private String project;

    /** 性别（0=男，1=女） */
    @Excel(name = "性别", readConverterExp = "0==男，1=女")
    private String sex;

    /** 身高（单位厘米） */
    @Excel(name = "身高", readConverterExp = "单=位厘米")
    private double height;

    /** 体重（单位千克） */
    @Excel(name = "体重", readConverterExp = "单=位千克")
    private double weight;

    /** 联系方式1 */
    @Excel(name = "联系方式1")
    private String telephone1;

    /** 联系方式2 */
    @Excel(name = "联系方式2")
    private String telephone2;

    /** 照片 */
    @Excel(name = "照片")
    private String photo;
    //存放网页图片的base64 数据
    private String photoData;

    /** 手机号 */
    @Excel(name = "手机号")
    private String phoneNumber;

    /** 密码 */
    @Excel(name = "密码")
    private String password;

    private String auditStatus;
}
