package yangtz.cs.liu.campus.vo.time;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.campus.vo.Course.SchoolCourseVO;

import java.util.Date;

@Data
public class ExportScheduleVo {
    private Long id;

    /** 序号 */
    private Integer sortId;

    /** 序号名称 */
    @Excel(name = "节次")
    private String sortName;

    /** 开始时间 */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "开始时间", dateFormat = "HH:mm")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "结束时间" , dateFormat = "HH:mm")
    private Date endTime;

    /** 备注 */
    private String remark;

    //星期一到星期日，本节次都有哪些课
    @Excel(name = "周一",combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String monday;
    @Excel(name = "周二",combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String tuesday;
    @Excel(name = "周三",combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String wednesday;
    @Excel(name = "周四",combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String thursday;
    @Excel(name = "周五",combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String friday;
    @Excel(name = "周六",combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String saturday;
    @Excel(name = "周日",combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String sunday;
}
