package yangtz.cs.liu.campus.vo.teacher;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class TeacherOvertimeVO extends ProcessBaseEntity {

    private Long id;
    /**
     * 教师id
     */
    @NotNull(message = "老师id不能为空")
    private Long teacherId;

    /**
     * 教师姓名
     */
    @Excel(name = "教师姓名")
    @NotBlank(message = "老师姓名不能为空")
    private String teacherName;

    /**
     * 所在部门
     */
    @Excel(name = "所在部门")
    @NotBlank(message = "所在部门不能为空")
    private String department;

    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始时间不能为空")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束时间不能为空")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 加班天数
     */
    @Excel(name = "加班天数")
    @NotBlank(message = "加班天数不能为空")
    private String days;

    /**
     * 加班原因
     */
    @Excel(name = "加班原因")
    @NotBlank(message = "加班原因不能为空")
    private String reason;

    /**
     * 状态
     */
    private Long state;
    /**
     * 流程实例ID
     **/
    private String instanceId;
    /**
     * 类型
     **/
    private String type;
    /**
     * 申请人姓名
     **/
    private String applyUser;

    /**
     * 实际开始时间
     */
    private Date realityStartTime;
    /**
     * 实际结束时间
     */
    private Date realityEndTime;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date applyTime;
}
