package yangtz.cs.liu.campus.vo.teacher;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class TeacherLeaveVO extends ProcessBaseEntity {

    private Long id;
    /**
     * 请假类型
     */
    private String type;

    /**
     * 标题
     */
    private String title;

    /**
     * 老师id
     */
    @NotNull(message = "老师id不能为空")
    private Long teacherId;

    /**
     * 老师名称
     */
    @Excel(name = "老师名称")
    @NotBlank(message = "老师名称不能为空")
    private String teacherName;

    /**
     * 请假原因
     */
    @Excel(name = "请假原因")
    @NotBlank(message = "请假原因不能为空")
    private String reasonForLeave;

    /**
     * 请假开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "请假开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "请假开始时间不能为空")
    private Date startTime;

    /**
     * 请假开始节次（1-8）
     */
    @Excel(name = "请假开始节次（1-8）")
    private String startSort;

    /**
     * 请假结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "请假结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "请假结束时间不能为空")
    private Date endTime;

    /**
     * 请假结束节次（1-8）
     */
    @Excel(name = "请假结束节次（1-8）")
    private String endSort;

    /**
     * 状态
     */
    private String state;


    /**
     * 请假时长，单位天
     */
    @Excel(name = "请假时长")
    private Double totalTime;

    /**
     * 流程实例ID
     */
    @Excel(name = "流程实例ID")
    private String instanceId;

    /**
     * 申请人
     */
    private String applyUser;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    /**
     * 申请人类型（0教工 1职工）
     */
    private String applyType;

    /**
     * 申请人级部/处室
     */
    private Long applyOrgid;

    /** 申请人级部/处室名称 */
    private String applyOrgname;

    /**
     * 审批人 id1
     */
    @NotNull(message = "级部/处室主任id不能为空")
    private Long handUserId1;

    /** 审批人名字1 */
    @NotBlank(message = "级部/处室主任名称不能为空")
    private String handUserName1;

    /**
     * 审批人 id2
     */
//    @NotNull(message = "审批人不能为空")
    private Long handUserId2;

    /** 审批人名字2 */
    private String handUserName2;

    /**
     * 审批人 id3
     */
//    @NotNull(message = "审批人不能为空")
    private Long handUserId3;

    /** 审批人名字3 */
    private String handUserName3;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /** 创建人*/
    private String createBy;

    private String deptName;

    //教工请假时长显示为X天Y节课
    private String dayCourse;

    private String teacherTel;
}
