package yangtz.cs.liu.campus.vo.student;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class StudentLeaveVO extends ProcessBaseEntity {

    private Long id;

    @NotNull(message = "学生id不能为空")
    private Long studentId;

    /**
     * 请假原因
     */
    @Excel(name = "请假原因")
    @NotBlank(message = "请假原因不能为空")
    private String leaveReason;

    /**
     * 学生名称
     */
    @Excel(name = "学生名称")
    @NotBlank(message = "学生名称")
    private String studentName;

    /**
     * 请假开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @NotNull(message = "请假开始时间")
    @Excel(name = "请假开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 请假结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @NotNull(message = "请假结束时间")
    @Excel(name = "请假结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 请假类型
     */
    @Excel(name = "请假类型")
    private String type;

    /**
     * 状态 (0 通过, 1 驳回,2暂存，3待审批)
     */
    private String state;

    /**
     * 标题
     */
    @Excel(name = "标题")
    private String title;

    /**
     * 请假时长，单位天
     */
    @Excel(name = "请假时长")
    private Double totalTime;

    /**
     * 流程实例ID
     */
    @Excel(name = "流程实例ID")
    private String instanceId;

    /** 申请人id */
    private Long applyUserId;

    /**
     * 申请人
     */
    @Excel(name = "申请人")
    private String applyUser;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "申请时间", dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    /**
     * 审核人id
     */
    private Long handUserId;

    /**
     * 审核人
     */
    @Excel(name = "审核人")
    private String handUserName;

    /** 创建时间 */
    private Date createTime;


    //    审批人 id2
    private Long handUserId2;
    /** 审批人名字2 */
    private String handUserName2;

    //所属班级
    private String className;

    private Long classId;

    //家长电话号码
    private String parentTel;

    //和学生关系
    private String relationship;

    //销假时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date revokeTime;
}
