package yangtz.cs.liu.campus.vo.schoolbudget;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.campus.domain.schoolbudget.SchoolBudgetDetails;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 预算项目对象 school_budget
 *
 * @author wengxiu
 * @date 2023-01-05
 */
@Data
public class SchoolBudgetVo extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 预算年度 */
    @Excel(name = "预算年度", needMerge = true)
    @NotBlank(message = "预算年度不能为空")
    private String budgetYear;

    /** 部门ID科室 */
    //@Excel(name = "部门ID科室")
    //@NotNull(message = "科室id不能为空")
    private Long deptId;

    /** 申请部门名称 */
    @Excel(name = "申请部门名称", needMerge = true)
    private String deptName;

    /** 项目名称 */
    @Excel(name = "项目名称", needMerge = true)
    @NotBlank(message = "项目名称不能为空")
    private String budgetName;

    /** 批复金额 */
    @Excel(name = "批复总额（万元）", needMerge = true)
//    @NotBlank(message = "批复总额不能为空")
    private BigDecimal giveMoney;

    /** 已使用金额（万元） */
    @Excel(name = "已使用金额（万元）", needMerge = true)
//    @NotBlank(message = "已使用金额不能为空")
    private BigDecimal amountSpent;

    /** 是否政府采购(0是 1否) */
    @Excel(name = "是否政府采购", combo = {"是","否"}, readConverterExp = "0=是,1=否", needMerge = true)
    @NotBlank(message = "是否政府采购不能为空")
    private String isGov;

    /** 说明 */
    @Excel(name = "备注", needMerge = true)
    private String remark;

    @Excel(name = "明细")
    private List<SchoolBudgetDetails> schoolBudgetDetailsList;

}
