package yangtz.cs.liu.campus.vo.schoolOfficial;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import org.joda.time.DateTime;
import yangtz.cs.liu.campus.domain.file.PubFile;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Data
public class SchoolOfficialVo extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 发文字号
     */
    @NotBlank(message = "发文字号不能为空")
    private String issuedNum;

    /**
     * 发文标题
     */
    @NotBlank(message = "发文标题不能为空")
    private String issuedName;

    /**
     * 收文时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date receiveDate;

    /**
     * 办理期限
     * */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date deadline;

    /**
     * 紧急程度(0一般 1紧急 2特急)
     */
    private String urgency;

    /**
     * 简介
     */
    private String remarks;

    /**
     * 状态（0待发文 1流转中 2已完结）
     */
    private String state;

    /**
     * 主键id
     */
    private Long officialId;

    /**
     * 接收人id
     */
    @NotNull(message = "批阅人不能为空")
    private Long receiveUser;

    private String userName;


    /**
     * 接收人类型
     */
    private String receiveType;

    /**
     * 意见
     */
    private String opinion;

    /**
     * 结束时间
     */
    private Date finishTime;

    /**多附件*/
    List<PubFile> fileList;
}
