package yangtz.cs.liu.campus.vo.schoolEquipment;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;

/**
 * 设备报修对象 school_equipment_repair
 *
 * @author ruoyi
 * @date 2023-08-09
 */
@Data
public class SchoolEquipmentRepairVo extends BaseEntity
{

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 设备id */
    private Long equipmentId;

    /** 自编码 */
    @Excel(name = "自编码")
    private String encode;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String equipmentName;

    /** 型号 */
    @Excel(name = "型号")
    private String model;

    /** 投产日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "投产日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date dateOfProduction;

    /** 地点 */
    @Excel(name = "地点")
    private String place;

    /** 分类编码 */
    private String classificationCode;

    /** 报修时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "报修时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date reportRepairTime;

    /** 报修人id */
    private Long reportRepairId;

    /** 报修人 */
    @Excel(name = "报修人")
    private String reportRepair;

    /** 问题 */
    @Excel(name = "问题")
    private String problem;

    /** 修理人id */
    private Long repairId;

    /** 修理人 */
    @Excel(name = "修理人")
    private String repairName;

    /** 修理人联系方式 */
    @Excel(name = "修理人联系方式")
    private Long repairPhone;

    /** 修理时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "修理时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date repairTime;

    /** 修理状态（0已维修，1已损坏） */
    @Excel(name = "修理结果", readConverterExp = "0=已维修,1=已损坏")
    private String repairState;

    /** 处理状态（1已处理，0待处理） */
    @Excel(name = "处理状态", readConverterExp = "1=已处理,0=待处理")
    private String disposeState;

    /** 评价（1一星，2二星，3三星，4四星，5五星） */
    @Excel(name = "评价", readConverterExp = "1=一星，2二星，3三星，4四星，5五星")
    private Long evaluate;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;
}
